/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;

public final class FontUtils {
    private static final int BOLD_ITALIC = 3;
    public static final int DIRTY_STYLE = 1;

    private FontUtils() {
    }

    public static Font getCancelledFont(Font font) {
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        return new Font(attributes);
    }

    public static Font getCancelledFont(Component comp) {
        return FontUtils.getCancelledFont(comp.getFont());
    }

    public static Font getInactiveFont(Font font) {
        return FontUtils.addStyle(font, 2);
    }

    public static Font getInactiveFont(Component comp) {
        return FontUtils.getInactiveFont(comp.getFont());
    }

    public static Font getNonSelectableFont(Font font) {
        return FontUtils.addStyle(font, 2);
    }

    public static Font getNonSelectableFont(Component comp) {
        return FontUtils.getNonSelectableFont(comp.getFont());
    }

    public static Font getDirtyFont(Font font) {
        return FontUtils.addStyle(font, 1);
    }

    public static Font getDirtyFont(Component comp) {
        return FontUtils.getDirtyFont(comp.getFont());
    }

    public static Font addStyle(Font font, int newStyle) {
        int oldStyle = font.getStyle();
        if (oldStyle != newStyle && oldStyle < 3) {
            return font.deriveFont(oldStyle + newStyle);
        }
        return font;
    }
}

