/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.database;

import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.filerunner.core.StringUtils;
import java.awt.Color;
import java.util.Objects;

public class RunnerServerConfig
extends DatabaseServerConfig {
    private transient boolean urlSelected;
    private Color serverColor;
    private boolean enabled = true;
    private int id;

    public RunnerServerConfig() {
    }

    public RunnerServerConfig(RunnerServerConfig config) {
        this.databaseProvider = config.getDatabaseProvider();
        this.options = config.getOptions();
        this.password = config.getPassword();
        this.server = config.getServer();
        this.serverLabel = config.getServerLabel();
        this.url = config.getUrl();
        this.useAD = config.getUseAD();
        this.user = config.getUser();
        this.urlSelected = StringUtils.isNotEmpty(this.url);
        this.serverColor = config.serverColor;
        this.enabled = config.enabled;
        this.id = config.id;
    }

    public boolean isUrlSelected() {
        return this.urlSelected;
    }

    public void setUrlSelected(boolean urlSelected) {
        this.urlSelected = urlSelected;
    }

    public Color getServerColor() {
        return this.serverColor;
    }

    public void setServerColor(Color serverColor) {
        this.serverColor = serverColor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.urlSelected ? 1 : 0) * 99 + (this.serverColor != null ? this.serverColor.hashCode() : 0) + (this.enabled ? 0 : 1) * 17;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            RunnerServerConfig conf = (RunnerServerConfig)obj;
            return Objects.equals(this.serverColor, conf.serverColor) && Objects.equals(this.enabled, conf.enabled);
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

