/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.database;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.DatabaseCellRenderer;
import com.sigge.filerunner.view.database.AddDatabase;
import com.sigge.filerunner.view.database.AddDatabaseModel;
import com.sigge.filerunner.view.database.AddDatabaseView;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.IView;
import com.siggemannen.core.ListUtils;
import com.siggemannen.view.UIBackgroundRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;

public class AddDatabasePresenter
extends APresenter<AddDatabase, AddDatabaseModel, AddDatabaseView> {
    private boolean hasSomeChanges;
    private boolean potentialChanges;
    private final DatabaseManager dbManager;
    private final SQLManager manager;

    public AddDatabasePresenter(AddDatabaseModel model, AddDatabaseView view, DatabaseManager dbManager, SQLManager manager) {
        super((AModel)model, (IView)view);
        this.dbManager = dbManager;
        this.manager = manager;
    }

    protected void initBindings() {
        this.bind(((AddDatabaseView)this.view).serverText).to(((AddDatabaseModel)this.model).server);
        this.bind(((AddDatabaseView)this.view).loginText).to(((AddDatabaseModel)this.model).user);
        this.bind(((AddDatabaseView)this.view).passText).to(((AddDatabaseModel)this.model).password);
        this.bind(((AddDatabaseView)this.view).adLoginCheckbox).to(((AddDatabaseModel)this.model).useAD);
        this.bind(((AddDatabaseView)this.view).urlTextField).to(((AddDatabaseModel)this.model).url);
        this.bind(((AddDatabaseView)this.view).serverDisplayNameText).to(((AddDatabaseModel)this.model).serverLabel);
        this.bind(((AddDatabaseView)this.view).serverTypeCombobox).to(this.dbManager.getSupportedProviders(), ((AddDatabaseModel)this.model).databaseProvider);
        this.bind(((AddDatabaseView)this.view).chkBoxURL).to(((AddDatabaseModel)this.model).urlSelected);
        this.bind(((AddDatabaseView)this.view).serverEnabled).to(((AddDatabaseModel)this.model).enabled);
        ((AddDatabaseView)this.view).savedConfigCombo.setModel(((AddDatabaseModel)this.model).serverModel);
        final HashMap icons = new HashMap();
        this.dbManager.getSupportedProviders().forEach(f -> {
            try {
                icons.put(f, IconUtils.getSmallIcon(String.valueOf(f) + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ((AddDatabaseView)this.view).serverTypeCombobox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel j = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ImageIcon ico = (ImageIcon)icons.get(value);
                if (ico != null) {
                    j.setIcon(ico);
                }
                return j;
            }
        });
        ((AddDatabaseView)this.view).savedConfigCombo.setRenderer(new DatabaseCellRenderer());
        ((AddDatabaseView)this.view).changeColor.addActionListener(l -> this.chooseColor());
        ((AddDatabaseView)this.view).colorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ButtonUtils.isRightClick(e)) {
                    AddDatabasePresenter.this.chooseColor();
                }
            }
        });
        ((AddDatabaseView)this.view).newButton.addActionListener(l -> this.createNewDatabase(new RunnerServerConfig()));
        ((AddDatabaseView)this.view).duplicateButton.addActionListener(l -> {
            RunnerServerConfig copy = new RunnerServerConfig((RunnerServerConfig)((AddDatabaseModel)this.model).serverModel.getSelectedItem());
            copy.setId(0);
            this.createNewDatabase(copy);
        });
        ((AddDatabaseView)this.view).removeButton.addActionListener(l -> {
            ((AddDatabaseModel)this.model).serverModel.removeElement((Object)((RunnerServerConfig)((AddDatabaseModel)this.model).serverModel.getSelectedItem()));
            this.potentialChanges = true;
        });
        ((AddDatabaseView)this.view).saveButton.addActionListener(l -> this.saveChanges());
        ((AddDatabaseView)this.view).setDefaultCloseOperation(0);
        ((AddDatabaseView)this.view).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                AddDatabasePresenter.this.checkDisposing();
            }
        });
        ((AddDatabaseView)this.view).adLoginCheckbox.addActionListener(l -> {
            if (((AddDatabaseView)this.view).adLoginCheckbox.isSelected()) {
                ((AddDatabaseModel)this.model).user.setValue((Object)"");
                ((AddDatabaseModel)this.model).password.setValue((Object)"");
            }
            ((AddDatabaseView)this.view).loginText.setEnabled(!((AddDatabaseView)this.view).adLoginCheckbox.isSelected());
            ((AddDatabaseView)this.view).passText.setEnabled(!((AddDatabaseView)this.view).adLoginCheckbox.isSelected());
        });
        ((AddDatabaseView)this.view).refreshButton.addActionListener(l -> this.testLoadServer());
        ((AddDatabaseView)this.view).goButton.addActionListener(l -> this.checkDisposing());
        ((AddDatabaseView)this.view).revertChangesButton.addActionListener(l -> {
            ((AddDatabaseModel)this.model).revert();
            RunnerServerConfig selectedItem = (RunnerServerConfig)((AddDatabaseModel)this.model).serverModel.getSelectedItem();
            ((AddDatabaseModel)this.model).serverModel.setSelectedItem(null);
            ((AddDatabaseModel)this.model).serverModel.setSelectedItem((Object)selectedItem);
        });
    }

    private void chooseColor() {
        Color newColor = JColorChooser.showDialog((Component)this.view, "Choose Background Color", (Color)((AddDatabaseModel)this.model).serverColor.getValue());
        ((AddDatabaseModel)this.model).serverColor.setValue((Object)newColor);
    }

    private void checkDisposing() {
        if (this.potentialChanges && ((AddDatabaseModel)this.model).isDirty()) {
            int opt = JOptionPane.showOptionDialog((Component)this.view, "You have some unchanged edits, do you want to SAVE before exiting dialog?", "Confirm exit", 1, 3, null, new String[]{"Save changes", "Discard changes", "Don't exit"}, "Save changes");
            if (opt == 0) {
                this.saveChanges();
                ((AddDatabaseView)this.view).dispose();
                return;
            }
            if (opt == 1) {
                ((AddDatabaseModel)this.model).revertWithoutNotify();
                ((AddDatabaseView)this.view).dispose();
                return;
            }
            return;
        }
        ((AddDatabaseView)this.view).dispose();
    }

    private void saveChanges() {
        List<RunnerServerConfig> dbs = ((AddDatabaseModel)this.model).serverModel.getObject().stream().filter(this.dbManager::isValid).collect(Collectors.toList());
        Config c = ConfigHandler.getConfig();
        c.setDatabases(dbs);
        c.assignDatabaseIds();
        ConfigHandler.saveInBackground();
        this.hasSomeChanges = true;
        ((AddDatabaseModel)this.model).apply();
    }

    protected void afterObjectSet() {
        RunnerServerConfig rowAt = (RunnerServerConfig)((AddDatabaseModel)this.model).servers.getRowAt(0);
        ServerDatabase sd = this.manager.getCurrent();
        if (sd != null && sd.getDb() instanceof DatabaseFromConfig) {
            DatabaseFromConfig db = (DatabaseFromConfig)sd.getDb();
            RunnerServerConfig config = db.getConfig();
            int i = 0;
            while (i < ((AddDatabaseModel)this.model).servers.size()) {
                RunnerServerConfig conf = (RunnerServerConfig)((AddDatabaseModel)this.model).servers.getRowAt(i);
                if (Objects.equals(conf, config)) {
                    rowAt = conf;
                    break;
                }
                ++i;
            }
        }
        ((AddDatabaseModel)this.model).serverModel.setSelectedItem((Object)rowAt);
        this.addListenersToProperties(() -> this.changeValue(), new IProperty[]{((AddDatabaseModel)this.model).server, ((AddDatabaseModel)this.model).user, ((AddDatabaseModel)this.model).password, ((AddDatabaseModel)this.model).useAD, ((AddDatabaseModel)this.model).databaseProvider, ((AddDatabaseModel)this.model).url, ((AddDatabaseModel)this.model).serverColor});
        ((AddDatabaseView)this.view).chkBoxURL.addActionListener(a -> this.changeValue());
        this.changeValue();
        ((AddDatabaseModel)this.model).addModelChangeListener(() -> {
            this.potentialChanges = true;
        });
        ((AddDatabaseModel)this.model).servers.addListener(((AddDatabaseView)this.view).dbList::removeAll);
    }

    private void changeValue() {
        ((AddDatabaseView)this.view).refreshButton.setEnabled(this.isValid((String)((AddDatabaseModel)this.model).server.getValue(), (String)((AddDatabaseModel)this.model).user.getValue(), (String)((AddDatabaseModel)this.model).password.getValue(), (Boolean)((AddDatabaseModel)this.model).useAD.getValue(), (String)((AddDatabaseModel)this.model).url.getValue()));
        boolean jdbcUrlMode = ListUtils.in((Object)(((AddDatabaseModel)this.model).databaseProvider.getValue() != null ? ((String)((AddDatabaseModel)this.model).databaseProvider.getValue()).toLowerCase() : ""), (Object[])new String[]{"JDBC", "ORACLE"});
        ((AddDatabaseView)this.view).chkBoxURL.setEnabled(!jdbcUrlMode);
        if (jdbcUrlMode && !Boolean.TRUE.equals(((AddDatabaseModel)this.model).urlSelected.getValue())) {
            ((AddDatabaseModel)this.model).urlSelected.setValue((Object)true);
        }
        ((AddDatabaseView)this.view).colorLabel.setBackground((Color)((AddDatabaseModel)this.model).serverColor.getValue());
        jdbcUrlMode = (Boolean)((AddDatabaseModel)this.model).urlSelected.getValue();
        ((AddDatabaseView)this.view).duplicateButton.setEnabled(StringUtils.isNotEmpty((String)((AddDatabaseModel)this.model).server.getValue()) || StringUtils.isNotEmpty((String)((AddDatabaseModel)this.model).url.getValue()));
        ((AddDatabaseView)this.view).urlTextField.setEditable(jdbcUrlMode);
        ((AddDatabaseView)this.view).loginText.setEditable(!jdbcUrlMode && (Boolean)((AddDatabaseModel)this.model).useAD.getValue() == false);
        ((AddDatabaseView)this.view).passText.setEditable(!jdbcUrlMode && (Boolean)((AddDatabaseModel)this.model).useAD.getValue() == false);
        ((AddDatabaseView)this.view).adLoginCheckbox.setEnabled(!jdbcUrlMode);
        ((AddDatabaseView)this.view).serverText.setEditable(!jdbcUrlMode);
        ((AddDatabaseView)this.view).adLoginCheckbox.setEnabled(!jdbcUrlMode);
        ((AddDatabaseView)this.view).savedConfigCombo.repaint();
        ((AddDatabaseView)this.view).serverTypeCombobox.repaint();
    }

    private void testLoadServer() {
        Database db = null;
        try {
            db = this.generateServer((AddDatabaseModel)this.model);
            if (db != null) {
                ((AddDatabaseView)this.view).urlPreview.setText(db.getConnectionUrl());
                ((AddDatabaseView)this.view).urlPreview.setToolTipText(db.getConnectionUrl());
                UIBackgroundRunner.execute((RootPaneContainer)((RootPaneContainer)this.view), db::getDatabases, l -> this.setDatabaseOnList((List<String>)l), e -> JOptionPane.showMessageDialog((Component)this.view, e.getMessage(), "Error while loading", 2), () -> {}, (String)"Loading databases", (String)"Trying to load databases", (String)"Cancel loading");
            }
        }
        finally {
            if (db != null) {
                db.closeAllSessions();
            }
        }
    }

    void unwind(Exception e) {
        ((AddDatabaseView)this.view).getGlassPane().setVisible(false);
        ((AddDatabaseView)this.view).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        if (e != null) {
            JOptionPane.showMessageDialog((Component)this.view, "Exception occured:" + e.getMessage(), "Error", 0);
        }
    }

    private boolean isValid(String server, String user, String password, Boolean useAD, String url) {
        return StringUtils.isNotEmpty(url) || StringUtils.isNotEmpty(server) && (Boolean.TRUE.equals(useAD) || StringUtils.isNoneEmpty(user));
    }

    private void setDatabaseOnList(List<String> l) {
        ((AddDatabaseView)this.view).dbList.setListData((String[])l.toArray(new String[0]));
        this.unwind(null);
    }

    private Database generateServer(AddDatabaseModel model) {
        String server = (String)model.server.getValue();
        String password = (String)model.password.getValue();
        String user = (String)model.user.getValue();
        boolean useAD = (Boolean)model.useAD.getValue();
        String url = (String)model.url.getValue();
        String serverLabel = (String)model.serverLabel.getValue();
        RunnerServerConfig config = new RunnerServerConfig();
        config.setServer(server);
        config.setPassword(password);
        config.setUser(user);
        config.setUseAD(useAD);
        config.setUrl(url);
        config.setServerLabel(serverLabel);
        config.setServerColor((Color)model.serverColor.getValue());
        config.setEnabled((Boolean)model.enabled.getValue());
        config.setDatabaseProvider((String)model.databaseProvider.getValue());
        if (!this.dbManager.isValid(config)) {
            JOptionPane.showMessageDialog((Component)this.view, "Connection URL or server settings aren't valid");
            return null;
        }
        try {
            return this.dbManager.generateServer(config);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void createNewDatabase(RunnerServerConfig l) {
        ((AddDatabaseView)this.view).dbList.setListData((String[])new String[0]);
        ((AddDatabaseModel)this.model).serverModel.addElement((Object)l);
        ((AddDatabaseModel)this.model).serverModel.setSelectedItem((Object)l);
        ((AddDatabaseView)this.view).serverText.requestFocusInWindow();
    }

    public boolean hasSomeChanges() {
        return this.hasSomeChanges;
    }
}

