/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.view.core.FindColumnAction;
import com.sigge.filerunner.view.core.MenuScroller;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableCellRenderer;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableComponentTip;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnControlPopup;

public class VTreeTable
extends JXTreeTable {
    private final FocusableComponentTip focusableTip = new FocusableComponentTip((JComponent)((Object)this), null);
    private static final String FIND_COLUMN_ACTION = "column..1.findColumns";
    static final Field renderer = VTreeTable.getTreeRenderer();

    public VTreeTable() {
        this.setGridColor();
    }

    private static Field getTreeRenderer() {
        try {
            return JXTreeTable.class.getDeclaredField("renderer");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setLeftPadding(int padding) {
        if (renderer != null) {
            try {
                try {
                    TreeUI ui;
                    renderer.setAccessible(true);
                    JXTree treerenderer = (JXTree)renderer.get((Object)this);
                    if (treerenderer != null && (ui = treerenderer.getUI()) instanceof BasicTreeUI) {
                        BasicTreeUI basicTreeUI = (BasicTreeUI)ui;
                        basicTreeUI.setLeftChildIndent(padding);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    renderer.setAccessible(false);
                }
            }
            finally {
                renderer.setAccessible(false);
            }
        }
    }

    private void setGridColor() {
        this.setGridColor(new Color(223, 220, 214));
    }

    public String getToolTipText(MouseEvent event) {
        String tip = super.getToolTipText(event);
        if (tip != null) {
            return tip;
        }
        Point p = event.getPoint();
        int row = this.rowAtPoint(p);
        int column = this.columnAtPoint(p);
        if (row == -1 || column == -1) {
            return null;
        }
        TableCellRenderer renderer = this.getCellRenderer(row, column);
        Component c = renderer.getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(row, column), false, false, row, column);
        String text = null;
        if (c.getPreferredSize().width > this.getCellRect((int)row, (int)column, (boolean)false).width) {
            if (c instanceof JLabel) {
                text = ((JLabel)c).getText();
            }
            if (c instanceof JButton) {
                text = ((JButton)c).getText();
            }
        }
        if (text != null) {
            this.focusableTip.setImageBase(null);
            this.focusableTip.toolTipRequested(p, text);
        } else if (this.focusableTip != null) {
            this.focusableTip.possiblyDisposeOfTipWindow();
        }
        return null;
    }

    protected JComponent createDefaultColumnControl() {
        ActionMap map = this.getActionMap();
        map.put(FIND_COLUMN_ACTION, new FindColumnAction((JXTable)this));
        this.getInputMap().put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), FIND_COLUMN_ACTION);
        return new VColumnControlButton((JXTable)this);
    }

    public class VColumnControlButton
    extends ColumnControlButton {
        public VColumnControlButton(JXTable table) {
            super(table);
        }

        public VColumnControlButton(JXTable table, Icon icon) {
            super(table, icon);
        }

        protected void populatePopup() {
            super.populatePopup();
            MenuScroller.setScrollerFor(((VColumnControlPopup)this.popup).getPopup(), 20, 150, 0, 4);
        }

        protected ColumnControlPopup createColumnControlPopup() {
            return new VColumnControlPopup();
        }

        public class VColumnControlPopup
        extends ColumnControlButton.DefaultColumnControlPopup {
            public VColumnControlPopup() {
                super((ColumnControlButton)VColumnControlButton.this);
            }

            public JPopupMenu getPopup() {
                return this.getPopupMenu();
            }
        }
    }
}

