/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class VTableColumnFactory
extends ColumnFactory {
    public static final int DEFAULT_MAX_ROWS_WHEN_CALCULATING_COLUMN_WIDTHS = 100;
    private static final int CHECKBOX_COLUMN_PADDING = 14;
    private final JLabel label = new JLabel();
    private int maxRowCountForTablePacking = 100;

    public void configureColumnWidths(JXTable table, TableColumnExt column) {
        super.configureColumnWidths(table, column);
        if (this.isBoolean(table, column)) {
            this.setCheckBoxWidth(column);
        }
    }

    private void setCheckBoxWidth(TableColumnExt column) {
        int width = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), column.getTitle()) + 14;
        column.setMaxWidth(width);
        column.setPreferredWidth(width);
    }

    private boolean isBoolean(JXTable table, TableColumnExt column) {
        Class<?> columnClass = table.getModel().getColumnClass(column.getModelIndex());
        return Boolean.class.equals(columnClass) || Boolean.TYPE.equals(columnClass);
    }

    public void setMaxRowCountForTablePacking(int value) {
        this.maxRowCountForTablePacking = value;
    }

    protected int getRowCount(JXTable table) {
        return Math.min(super.getRowCount(table), this.maxRowCountForTablePacking);
    }
}

