/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.core.DateUtils;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.Timer;

public class TimerLabel
extends JLabel {
    private float sec = 0.0f;
    private final Timer timer;
    private LocalDateTime start;
    private final double interval = 1.0;
    private boolean wentBackward = false;
    private String previousRunLabel = null;

    public TimerLabel(String text) {
        super(text);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setFont(this.getFont().deriveFont(13.0f));
        this.timer = new Timer(150, l -> {
            this.sec = (float)((double)this.sec + 150.0);
            this.updateLabel();
        });
    }

    public void start() {
        this.setToolTipText(this.previousRunLabel != null ? "Previous run: " + this.previousRunLabel : null);
        this.setText("00:00:00");
        this.start = DateUtils.getTimeAtUTC();
        this.sec = 0.0f;
        this.wentBackward = false;
        this.timer.start();
    }

    public void end() {
        this.timer.stop();
        this.updateLabel();
        this.sec = 0.0f;
        this.setToolTipText("<html>Current run: " + this.getText() + (this.previousRunLabel != null ? "<br><i>Previous run: " + this.previousRunLabel + "</i>" : ""));
        this.previousRunLabel = this.getText();
    }

    private void updateLabel() {
        LocalDateTime end = DateUtils.getTimeAtUTC();
        if (!this.wentBackward && end.compareTo(this.start) > 0) {
            long zec = ChronoUnit.MILLIS.between(this.start, end);
            int hours = (int)(zec / 3600000L);
            int mins = (int)(zec % 3600000L / 60000L);
            int secs = (int)(zec % 60000L / 1000L);
            int millis = (int)(zec % 1000L);
            this.setText(String.format("%02d:%02d:%02d.%03d", hours, mins, secs, millis));
        } else {
            this.wentBackward = true;
            int hours = (int)(this.sec / 1000.0f / 3600.0f);
            int mins = (int)(this.sec / 1000.0f % 3600.0f / 60.0f);
            int secs = (int)Math.ceil(this.sec / 1000.0f % 60.0f);
            this.setText(String.format("%02d:%02d:%02d", hours, mins, secs));
        }
    }
}

