/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.RowFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowFilterExtension<E>
extends RowFilter<Object, Number>
implements Comparator<E> {
    private int limit = 0;
    protected final Map<E, Boolean> map = new HashMap<E, Boolean>();
    private E selected;
    private static final Logger LOGGER = LoggerFactory.getLogger(RowFilterExtension.class);
    private final Map<E, Integer> hits = new HashMap<E, Integer>();
    private Comparator<E> comparator;

    public RowFilterExtension(int limit, Comparator<E> comparator) {
        this.limit = limit;
        this.comparator = comparator;
    }

    public RowFilterExtension(int limit) {
        this(limit, null);
    }

    public RowFilterExtension() {
        this(123123123);
    }

    public void hit(E element) {
        this.hits.merge(element, 1, (i, j) -> i + j);
    }

    @Override
    public boolean include(RowFilter.Entry<? extends Object, ? extends Number> entry) {
        return this.map.containsKey(entry.getValue(0));
    }

    public void filterOut(Stream<E> values, E previouslySelected) {
        this.map.clear();
        this.selected = previouslySelected;
        HashMap prio = new HashMap();
        ArrayList nonPrio = new ArrayList();
        values.forEach(l -> {
            if (this.hits.containsKey(l) || l.equals(previouslySelected)) {
                prio.put(l, l.equals(previouslySelected) ? Integer.MAX_VALUE : this.hits.get(l));
            } else {
                nonPrio.add(l);
            }
        });
        this.map.putAll(prio.entrySet().stream().sorted((e, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e.getValue())).limit(this.limit).map(l -> l.getKey()).collect(Collectors.toMap(k -> k, v -> true)));
        int cntLeft = this.limit - this.map.size();
        if (cntLeft > 0) {
            this.map.putAll(nonPrio.stream().sorted(this::compare).limit(cntLeft).collect(Collectors.toMap(k -> k, v -> true, (a, b) -> {
                LOGGER.error("Found dups between: {} and {}", a, b);
                return a;
            })));
        }
    }

    public int getFilteredCount() {
        return this.map.keySet().size();
    }

    @Override
    public int compare(E o1, E o2) {
        int comp;
        if (o1.equals(this.selected)) {
            return -1;
        }
        if (o2.equals(this.selected)) {
            return 1;
        }
        Integer i = this.hits.get(o1);
        Integer i2 = this.hits.get(o2);
        if (i != null) {
            if (i2 == null) {
                return -1;
            }
            return i2.compareTo(i);
        }
        if (i2 != null) {
            return 1;
        }
        if (this.comparator != null && (comp = this.comparator.compare(o1, o2)) != 0) {
            return comp;
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return o1.toString().compareTo(o2.toString());
    }
}

