/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JTextField;

public class HintTextField
extends JTextField {
    protected String hint = "";

    public HintTextField() {
    }

    public HintTextField(String hint) {
        this.hint = hint;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.getText().length() == 0 && this.isEditable()) {
            int h = this.getHeight();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Insets ins = this.getInsets();
            FontMetrics fm = g.getFontMetrics();
            int c0 = this.getBackground().getRGB();
            int c1 = this.getForeground().getRGB();
            int m = -16843010;
            int c2 = ((c0 & m) >>> 1) + ((c1 & m) >>> 1);
            g.setColor(new Color(c2, true));
            g.drawString(this.getHint(), ins.left, h / 2 + fm.getAscent() / 2 - 2);
        }
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }
}

