/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.view.ColorUtils;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import java.awt.Color;

public class DatabaseUtils {
    public static String getColorBlob(DatabaseFromConfig config) {
        if (config == null) {
            return "";
        }
        RunnerServerConfig config2 = config.getConfig();
        if (config2 == null) {
            return "";
        }
        return DatabaseUtils.getColorBlob(config2);
    }

    public static String getColorBlob(RunnerServerConfig config) {
        return ColorUtils.getColorBlobFromColor(config != null ? config.getServerColor() : null);
    }

    public static String getColorBlob(Database db) {
        return ColorUtils.getColorBlobFromColor(DatabaseUtils.getColor(db));
    }

    public static Color getColor(Database db) {
        if (db instanceof DatabaseFromConfig) {
            RunnerServerConfig config = ((DatabaseFromConfig)db).getConfig();
            if (config != null) {
                return config.getServerColor();
            }
        } else if (db instanceof RunnerServerConfig) {
            return ((RunnerServerConfig)((Object)db)).getServerColor();
        }
        return null;
    }
}

