/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.changedb;

import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.core.DatabaseUtils;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class DatabaseComboboxConfigurer {
    public static void configureDatabaseCombo(JComboBox databaseCombo, final Runnable onSelection) {
        Border line = BorderFactory.createEtchedBorder(1);
        EmptyBorder empty = new EmptyBorder(0, 2, 0, 0);
        CompoundBorder border = new CompoundBorder(line, empty);
        databaseCombo.setBorder(border);
        AutoCompleteDecorator.decorate((JComboBox)databaseCombo, (ObjectToStringConverter)new DbComboConverter(databaseCombo));
        databaseCombo.setRenderer(new DatabaseCheckBoxRenderer());
        databaseCombo.getEditor().addActionListener(l -> {
            Object item = databaseCombo.getSelectedItem();
            if (item != null) {
                databaseCombo.getEditor().setItem(item);
            }
        });
        databaseCombo.addActionListener(l -> {
            if ((l.getModifiers() & 0x10) == 0) {
                return;
            }
            onSelection.run();
        });
        ComboBoxCellEditor editor = new ComboBoxCellEditor(databaseCombo);
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                onSelection.run();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
    }

    private static class DatabaseCheckBoxRenderer
    implements ListCellRenderer<ServerDatabase> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private DatabaseCheckBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ServerDatabase> list, ServerDatabase value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String server = value.getDb() == null ? "" : " <font color=blue>" + value.getDb().getLabel() + "</font>";
                renderer.setText("<html>&nbsp;" + DatabaseUtils.getColorBlob((DatabaseFromConfig)value.getDb()) + value.getDatabase() + server + "</html>");
            }
            return renderer;
        }
    }

    public static final class DbComboConverter
    extends ObjectToStringConverter {
        private final JComboBox combo;

        DbComboConverter(JComboBox combo) {
            this.combo = combo;
        }

        public String getPreferredStringForItem(Object item) {
            if (item == null) {
                return "";
            }
            return ((ServerDatabase)item).getDatabase();
        }

        public JComboBox getCombo() {
            return this.combo;
        }
    }
}

