/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import com.sigge.filerunner.view.activity.IRunner;
import com.sigge.filerunner.view.activity.mysql.MysqlRunner;
import com.sigge.filerunner.view.activity.pgsql.PostgresMonitorer;
import com.sigge.filerunner.view.activity.sqlserver.SQLServerMonitorer;
import java.util.Optional;
import java.util.function.Function;

enum Runners {
    SQLSERVER(SQLServerDatabase.PROVIDER_NAME, SQLServerMonitorer::new),
    POSTGRES("POSTGRES", PostgresMonitorer::new),
    MYSQL("MYSQL", MysqlRunner::new);

    final String provider;
    final Function<Database, IRunner> supplier;

    private Runners(String provider, Function<Database, IRunner> supplier) {
        this.provider = provider;
        this.supplier = supplier;
    }

    static Optional<Runners> getFromProvider(String param) {
        Runners[] runnersArray = Runners.values();
        int n = runnersArray.length;
        int n2 = 0;
        while (n2 < n) {
            Runners r = runnersArray[n2];
            if (r.provider.equals(param)) {
                return Optional.of(r);
            }
            ++n2;
        }
        return Optional.empty();
    }
}

