/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.view.MainPanel;
import com.sigge.filerunner.view.core.JCheckBoxTree;
import com.sigge.filerunner.view.core.TimerLabel;
import com.siggemannen.binding.AView;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.plaf.basic.BasicStatusBarUI;

@Singleton
public class RunnerView
extends AView {
    private static final Border CREATE_EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 10, 0, 0);
    final JCheckBoxTree tree;
    final JXTable fileTable;
    final JTextField browseFolder;
    private final MainPanel panel;
    final JButton addDBButton;
    final JButton reloadDBButton;
    private final JXStatusBar statusBar;
    private JLabel statusLabel;
    private JLabel resultsLabel;
    private JPanel timerPanel;
    private JPanel runningIcon;
    private JLabel warningIcon;

    @Inject
    public RunnerView(MainPanel panel) {
        this.panel = panel;
        this.tree = panel.getCheckBoxTree();
        this.fileTable = panel.fileTable;
        this.browseFolder = panel.browseFolder;
        this.addDBButton = panel.addDBButton;
        this.reloadDBButton = panel.reloadDBButton;
        this.statusBar = panel.statusBar;
        this.prepareStatusBar();
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    private void prepareStatusBar() {
        this.statusBar.putClientProperty((Object)BasicStatusBarUI.AUTO_ADD_SEPARATOR, (Object)false);
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(CREATE_EMPTY_BORDER);
        this.resultsLabel = new JLabel();
        this.resultsLabel.setBorder(CREATE_EMPTY_BORDER);
        this.timerPanel = new JPanel(new BorderLayout());
        this.runningIcon = new JPanel();
        JXStatusBar.Constraint c1 = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        JPanel jepee = new JPanel(new BorderLayout());
        jepee.add((Component)this.statusLabel, "Center");
        this.statusBar.add((Component)jepee, (Object)c1);
        JPanel resultsPanel = new JPanel(new BorderLayout());
        resultsPanel.add((Component)this.resultsLabel, "Center");
        this.statusBar.add((Component)resultsPanel, (Object)this.constraint(300));
        this.statusBar.add((Component)this.timerPanel, (Object)this.constraint(95));
        this.statusBar.add((Component)new JSeparator(1));
        this.statusBar.add((Component)this.runningIcon, (Object)this.constraint(30));
        this.statusBar.revalidate();
    }

    private JXStatusBar.Constraint constraint(int width) {
        JXStatusBar.Constraint c = new JXStatusBar.Constraint();
        c.setFixedWidth(width);
        return c;
    }

    public MainPanel getPanel() {
        return this.panel;
    }

    public void setRunningLabel(TimerLabel label) {
        if (label == null) {
            return;
        }
        this.timerPanel.add((Component)label, "Center");
    }

    public void setTransactionCount(int count) {
        if (count > 0) {
            this.resultsLabel.setToolTipText("Query has " + count + " open transaction" + (count > 1 ? "s" : ""));
            this.warningIcon.setText("!");
        } else {
            this.resultsLabel.setToolTipText("Query has " + count + " open transaction" + (count > 1 ? "s" : ""));
            this.warningIcon.setText("");
        }
    }

    public void clearPreviousExecution() {
        this.timerPanel.removeAll();
        this.timerPanel.repaint();
        this.runningIcon.removeAll();
        this.runningIcon.repaint();
        this.resultsLabel.setText("");
    }

    public void setRunningIcon(JComponent cp) {
        if (cp == null) {
            return;
        }
        this.runningIcon.add(cp);
        this.runningIcon.repaint();
    }

    public void setResultsInfo(int numberOfRows, int numberOfResultSets, String sessionId) {
        this.setResultsInfo(numberOfRows, numberOfResultSets, sessionId, 0);
    }

    public void setResultsInfo(int numberOfRows, int numberOfResultSets, String sessionId, int tranCount) {
        String s = "";
        if (sessionId != null) {
            s = "<font style='font-size:10px; font-style: italic'>Session: (" + sessionId + ")&nbsp;&nbsp;</font>";
        }
        String tran = "";
        if (tranCount > 0) {
            tran = "<font style='font-size:10px; color: red'>, transactions: " + tranCount;
        }
        String rows = "";
        if (numberOfResultSets > 0) {
            rows = "<font style='font-size:10px'>Rows: " + numberOfRows + (numberOfResultSets > 1 ? ", results: " + numberOfResultSets : "") + "</font>";
        }
        this.resultsLabel.setText(String.format("<html> %s %s %s</html>", s, rows, tran));
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).hashCode()) + super.toString();
    }
}

