/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.view.IconUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class JMemoryFrame
extends JFrame {
    private boolean defaultSet = true;
    private static final Image DEFAULT_ICON = IconUtils.getIcon("flash.png").getImage();

    public JMemoryFrame(String title, String tag) {
        super(title);
        this.setIconImage(DEFAULT_ICON);
        this.setDefaultCloseOperation(0);
        String escapedTag = tag.replaceAll("[^a-zA-Z_ -]", "_");
        this.addWindowListener(new Listener(this, escapedTag));
        Config config = ConfigHandler.getConfig();
        boolean max = config.getBooleanConfigValue("viewConfig." + escapedTag + ".state", false);
        int width = config.getNumberConfigValue("viewConfig." + escapedTag + ".width", this.getWidth()).intValue();
        int height = config.getNumberConfigValue("viewConfig." + escapedTag + ".height", this.getHeight()).intValue();
        if (width > 0 && height > 0) {
            this.setSize(new Dimension(width, height));
            this.defaultSet = false;
        }
        if (max) {
            this.setExtendedState(6);
            this.defaultSet = false;
        }
    }

    public void centerOnCorrectScreen(Frame parent) {
        this.setLocationRelativeTo(new JFrame(parent == null ? null : parent.getGraphicsConfiguration()));
    }

    public boolean isDefault() {
        return this.defaultSet;
    }

    private class Listener
    extends WindowAdapter {
        private final JMemoryFrame frame;
        private final String tag;

        Listener(JMemoryFrame frame, String tag) {
            this.tag = tag;
            this.frame = frame;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Config config = ConfigHandler.getConfig();
            config.setConfigValue("viewConfig." + this.tag + ".state", (JMemoryFrame.this.getExtendedState() & 6) > 0);
            config.setConfigValue("viewConfig." + this.tag + ".width", this.frame.getWidth());
            config.setConfigValue("viewConfig." + this.tag + ".height", this.frame.getHeight());
            ConfigHandler.saveInBackground();
            this.frame.removeWindowListener(this);
        }
    }
}

