/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.Caret;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;

public class DefaultSearchListener
implements SearchListener {
    private final IEditorManager manager;
    private final IStatusUpdater su;
    private final String messageTag;

    public DefaultSearchListener(IEditorManager manager, IStatusUpdater su, String messageTag) {
        this.manager = manager;
        this.su = su;
        this.messageTag = messageTag;
    }

    public void searchEvent(SearchEvent e) {
        SearchEvent.Type type = e.getType();
        SearchContext context = e.getSearchContext();
        SearchResult result = null;
        RSyntaxTextArea textArea = this.manager.getCurrentTab();
        switch (type) {
            case MARK_ALL: {
                result = SearchEngine.markAll((RTextArea)textArea, context);
                break;
            }
            case FIND: {
                boolean revertRegex = false;
                if (!context.isRegularExpression() && !context.getSearchFor().matches(".*[^0-9A-Za-z @$%&=].*") && textArea.getDocument().getLength() > 10000) {
                    revertRegex = true;
                    context.setRegularExpression(true);
                }
                result = SearchEngine.find((JTextArea)textArea, context);
                if (revertRegex) {
                    context.setRegularExpression(false);
                }
                if (result.wasFound()) break;
                Caret c = textArea.getCaret();
                int pos = c.getDot();
                if (context.getSearchForward()) {
                    c.setDot(0);
                } else {
                    c.setDot(textArea.getDocument().getLength());
                }
                result = SearchEngine.find((JTextArea)textArea, context);
                if (result.wasFound()) break;
                c.setDot(pos);
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                break;
            }
            case REPLACE: {
                result = SearchEngine.replace((RTextArea)textArea, context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                break;
            }
            case REPLACE_ALL: {
                result = SearchEngine.replaceAll((RTextArea)textArea, context);
                JOptionPane.showMessageDialog(null, String.valueOf(result.getCount()) + " occurrences replaced.");
            }
        }
        String text = null;
        text = result.wasFound() ? "Text found; occurrences marked: " + result.getMarkedCount() : (type == SearchEvent.Type.MARK_ALL ? (result.getMarkedCount() > 0 ? "Occurrences marked: " + result.getMarkedCount() : "") : "Text not found");
        this.su.addMessage(text, this.messageTag);
    }

    public String getSelectedText() {
        TextPaneUtil.fixDotAndMarks((RTextArea)this.manager.getCurrentTab());
        return this.manager.getCurrentTab().getSelectedText();
    }
}

