/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxStylesheet;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanGraph;
import com.siggemannen.core.ListUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JComponent;

public class QueryPlanUtils {
    private static final String CLUSTERED_INDEX_SCAN = "Clustered Index Scan";
    private static final String CLUSTERED_INDEX_SEEK = "Clustered Index Seek";
    private static final String COMPUTE_SCALAR = "Compute Scalar";
    private static final String SELECT = "SELECT";
    private static final String SELECT_INTO = "SELECT INTO";
    private static final String INSERT = "INSERT";
    private static final String UPDATE = "UPDATE";
    private static final String DELETE = "DELETE";
    private static final String INDEX_INSERT = "Index Insert";
    private static final String CLUSTERED_INDEX_INSERT = "Clustered Index Insert";
    private static final String INDEX_SEEK = "Index Seek";
    private static final String INDEX_SCAN = "Index Scan";
    private static final String NESTED_LOOPS = "Nested Loops";
    private static final String HASH_MATCH = "Hash Match";
    private static final String DEFAULT_STYLE = "DEFAULT_STYLE";
    private static final String TABLE_SCAN = "Table Scan";
    private static final String TABLE_INSERT = "Table Insert";
    private static final String TABLE_UPDATE = "Table Update";
    private static final String TABLE_SPOOL = "Table Spool";
    private static final String TABLE_VALUED_FUNCTION = "Table-valued function";
    private static final String INDEX_SPOOL = "Index Spool";
    private static final String SORT = "Sort";
    private static final String FILTER = "Filter";
    private static final String SEQUENCE = "Sequence";
    private static final String TOP = "Top";
    private static final Map<String, String> STYLE_MAP = new HashMap<String, String>();

    public static QueryPlanGraph createQPGraph(JComponent j) {
        QueryPlanGraph mx = new QueryPlanGraph(j);
        mxStylesheet stylesheet = mx.getStylesheet();
        QueryPlanUtils.createStyle(stylesheet, CLUSTERED_INDEX_SCAN, "clustered_index_scan.png");
        QueryPlanUtils.createStyle(stylesheet, CLUSTERED_INDEX_SEEK, "clustered_index_seek.png");
        QueryPlanUtils.createStyle(stylesheet, CLUSTERED_INDEX_INSERT, "index_up.png");
        QueryPlanUtils.createStyle(stylesheet, COMPUTE_SCALAR, "scalar.png");
        QueryPlanUtils.createStyle(stylesheet, SELECT, "table_sql_select.png");
        QueryPlanUtils.createStyle(stylesheet, INSERT, "table_sql_add.png");
        QueryPlanUtils.createStyle(stylesheet, UPDATE, "table_sql_refresh.png");
        QueryPlanUtils.createStyle(stylesheet, DELETE, "table_sql_delete.png");
        QueryPlanUtils.createStyle(stylesheet, INDEX_INSERT, "index_add.png");
        QueryPlanUtils.createStyle(stylesheet, NESTED_LOOPS, "nested_loop.png");
        QueryPlanUtils.createStyle(stylesheet, INDEX_SEEK, "index_seek.png");
        QueryPlanUtils.createStyle(stylesheet, TABLE_SCAN, "table_selection_all.png");
        QueryPlanUtils.createStyle(stylesheet, SORT, "sort_descending.png");
        QueryPlanUtils.createStyle(stylesheet, INDEX_SCAN, "index_down.png");
        QueryPlanUtils.createStyle(stylesheet, FILTER, "table_selection_row.png");
        QueryPlanUtils.createStyle(stylesheet, TABLE_INSERT, "table_insert.png");
        QueryPlanUtils.createStyle(stylesheet, TABLE_SPOOL, "table_spool.png");
        QueryPlanUtils.createStyle(stylesheet, INDEX_SPOOL, "index_spool.png");
        QueryPlanUtils.createStyle(stylesheet, TABLE_VALUED_FUNCTION, "table_function.png");
        QueryPlanUtils.createStyle(stylesheet, SEQUENCE, "sequence.png");
        QueryPlanUtils.createStyle(stylesheet, TOP, "top.png");
        Hashtable<String, Object> defaultStyle = new Hashtable<String, Object>();
        defaultStyle.put(mxConstants.STYLE_VERTICAL_LABEL_POSITION, "bottom");
        defaultStyle.put(mxConstants.STYLE_VERTICAL_ALIGN, "top");
        defaultStyle.put(mxConstants.STYLE_TARGET_PERIMETER_SPACING, 10);
        defaultStyle.put(mxConstants.STYLE_SOURCE_PERIMETER_SPACING, 10);
        defaultStyle.put(mxConstants.STYLE_PERIMETER_SPACING, 5);
        stylesheet.putCellStyle(DEFAULT_STYLE, defaultStyle);
        STYLE_MAP.put(CLUSTERED_INDEX_SCAN, CLUSTERED_INDEX_SCAN);
        STYLE_MAP.put(CLUSTERED_INDEX_SEEK, CLUSTERED_INDEX_SEEK);
        STYLE_MAP.put(COMPUTE_SCALAR, COMPUTE_SCALAR);
        STYLE_MAP.put(SELECT, SELECT);
        STYLE_MAP.put(INSERT, INSERT);
        STYLE_MAP.put(UPDATE, UPDATE);
        STYLE_MAP.put(DELETE, DELETE);
        STYLE_MAP.put(SELECT_INTO, SELECT);
        STYLE_MAP.put(NESTED_LOOPS, NESTED_LOOPS);
        STYLE_MAP.put(INDEX_SEEK, INDEX_SEEK);
        STYLE_MAP.put(TABLE_SCAN, TABLE_SCAN);
        STYLE_MAP.put(INDEX_INSERT, INDEX_INSERT);
        STYLE_MAP.put(SORT, SORT);
        STYLE_MAP.put(INDEX_SCAN, INDEX_SCAN);
        STYLE_MAP.put(CLUSTERED_INDEX_INSERT, CLUSTERED_INDEX_INSERT);
        STYLE_MAP.put(FILTER, FILTER);
        STYLE_MAP.put(TABLE_INSERT, TABLE_INSERT);
        STYLE_MAP.put(TABLE_UPDATE, UPDATE);
        STYLE_MAP.put(TABLE_SPOOL, TABLE_SPOOL);
        STYLE_MAP.put(INDEX_SPOOL, INDEX_SPOOL);
        STYLE_MAP.put(TABLE_VALUED_FUNCTION, TABLE_VALUED_FUNCTION);
        STYLE_MAP.put(SEQUENCE, SEQUENCE);
        STYLE_MAP.put(TOP, TOP);
        return mx;
    }

    public static String getStyleForNode(Node n) {
        String type = n.getAttributeValue("StatementType");
        String val = STYLE_MAP.get(type);
        if (val != null) {
            return val;
        }
        String name = n.getName();
        if (name.equals("RelOp")) {
            String op = n.getAttributeValue("PhysicalOp");
            return STYLE_MAP.getOrDefault(op, DEFAULT_STYLE);
        }
        return DEFAULT_STYLE;
    }

    public static String getInfoForRelOp(Node relOp) {
        String logicalOperation = relOp.getAttributeValue("LogicalOp");
        String pOp = relOp.getAttributeValue("PhysicalOp");
        StringBuilder sb = new StringBuilder();
        if (NESTED_LOOPS.equals(pOp) || TABLE_SPOOL.equals(pOp) || INDEX_SPOOL.equals(pOp) || HASH_MATCH.equals(pOp)) {
            sb.insert(0, "\n").append(pOp).append("\n").append("(").append(logicalOperation).append(")");
        } else if (TOP.equals(pOp)) {
            QueryPlanUtils.extractTop(relOp, pOp, sb);
        } else if (ListUtils.in((Object)pOp, (Object[])new String[]{INDEX_INSERT, CLUSTERED_INDEX_INSERT, TABLE_INSERT, TABLE_UPDATE})) {
            QueryPlanUtils.extractTable(relOp, pOp, sb, "Update");
        } else if (ListUtils.in((Object)pOp, (Object[])new String[]{INDEX_SEEK, CLUSTERED_INDEX_SCAN, CLUSTERED_INDEX_SEEK, INDEX_SCAN})) {
            QueryPlanUtils.extractTable(relOp, pOp, sb, "IndexScan");
        } else if (TABLE_SCAN.equals(pOp)) {
            QueryPlanUtils.extractTable(relOp, pOp, sb, "TableScan");
        } else if (TABLE_VALUED_FUNCTION.equals(pOp)) {
            QueryPlanUtils.extractTable(relOp, pOp, sb, "TableValuedFunction");
        } else {
            sb.append(pOp);
        }
        return sb.toString();
    }

    private static void extractTable(Node relOp, String pOp, StringBuilder sb, String op) {
        Optional<? extends String> s = relOp.getFirstTransientNode(op, "ScalarInsert", "ScalarUpdate", "ScalarDelete").flatMap(n -> n.getNode("Object")).map(QueryPlanUtils.getIndexTable());
        sb.insert(0, "\n\n\n").append(pOp).append(s.orElse(""));
    }

    private static void extractTop(Node relOp, String pOp, StringBuilder sb) {
        relOp.getTransientNode(pOp).flatMap(n -> n.getNode("TopExpression")).flatMap(n -> n.getNode("ScalarOperator")).ifPresent(str -> {
            StringBuilder stringBuilder2 = sb.append(pOp).append(" ").append("(" + QueryPlanUtils.unescape(str.getAttributeValue("ScalarString"), "(", ")") + ")");
        });
    }

    private static Function<? super Node, ? extends String> getIndexTable() {
        return mx -> {
            String table = QueryPlanUtils.unescape(mx.getAttributeValue("Table"));
            String alias = mx.getAttributeValue("Alias");
            alias = alias == null ? "" : (QueryPlanUtils.unescape(alias).equals(table) ? "" : " " + alias);
            return "\n" + QueryPlanUtils.getDatabase(mx) + table + alias + StringUtils.concatWsStart("\n", QueryPlanUtils.getIndex(mx));
        };
    }

    private static String getDatabase(Node mx) {
        String db = mx.getAttributeValue("Database");
        return db == null ? "" : String.valueOf(QueryPlanUtils.unescape(db)) + "\n";
    }

    private static String getAlias(Node mx) {
        String alias = mx.getAttributeValue("Alias");
        return alias == null ? "" : " " + alias;
    }

    private static String getIndex(Node mx) {
        String index = mx.getAttributeValue("Index");
        return index == null ? "" : " (" + QueryPlanUtils.unescape(index) + ")";
    }

    public static String unescape(String identifier) {
        return QueryPlanUtils.unescape(identifier, "[", "]");
    }

    private static String unescape(String identifier, String start, String end) {
        if (identifier == null || identifier.length() < 2) {
            return identifier;
        }
        String subString = identifier;
        while (subString.length() >= 2 && subString.startsWith(start) && subString.endsWith(end)) {
            subString = subString.substring(1, subString.length() - 1);
        }
        return subString;
    }

    private static void createStyle(mxStylesheet stylesheet, String style, String image) {
        Hashtable<String, Object> styleX = new Hashtable<String, Object>();
        styleX.put(mxConstants.STYLE_SHAPE, "label");
        styleX.put(mxConstants.STYLE_IMAGE, "/com/sigge/filerunner/sql/sqlserver/queryplan/images/" + image);
        styleX.put(mxConstants.STYLE_VERTICAL_LABEL_POSITION, "bottom");
        styleX.put(mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, "top");
        styleX.put(mxConstants.STYLE_IMAGE_WIDTH, 24);
        styleX.put(mxConstants.STYLE_IMAGE_HEIGHT, 24);
        styleX.put(mxConstants.STYLE_TARGET_PERIMETER_SPACING, 10);
        styleX.put(mxConstants.STYLE_SOURCE_PERIMETER_SPACING, 10);
        styleX.put(mxConstants.STYLE_PERIMETER_SPACING, 5);
        stylesheet.putCellStyle(style, styleX);
    }

    public static String getEdgeInfoForRelOp(Node relOp) {
        Double dValue = Double.valueOf(relOp.getAttributeValue("EstimateRows"));
        String estimatedRows = BigDecimal.valueOf(dValue).stripTrailingZeros().toPlainString();
        Double actualValue = QueryPlanUtils.getNumberOfRows(relOp);
        if (actualValue != null) {
            return BigDecimal.valueOf(actualValue).stripTrailingZeros().toPlainString();
        }
        return estimatedRows;
    }

    public static String getStyleForEdge(Node relOperation) {
        Double rows = QueryPlanUtils.getNumberOfRows(relOperation);
        double estimated = Double.valueOf(relOperation.getAttributeValue("EstimateRows"));
        if (rows == null) {
            return "dashed=true;fontStyle:1;fontSize=11;labelBackgroundColor=#eeeeee;fontColor=#000000;strokeColor=#123412;strokeWidth=" + QueryPlanUtils.getWidthForNumber(estimated);
        }
        return "fontStyle:1;fontSize=11;labelBackgroundColor=#eeeeee;fontColor=#000000;strokeColor=#123412;strokeWidth=" + QueryPlanUtils.getWidthForNumber(rows);
    }

    private static double getWidthForNumber(Double estimated) {
        if (estimated < 5.0) {
            return 1.0;
        }
        if (estimated < 10.0) {
            return 1.2;
        }
        if (estimated < 20.0) {
            return 1.4;
        }
        if (estimated < 50.0) {
            return 1.6;
        }
        if (estimated < 100.0) {
            return 1.7;
        }
        if (estimated < 250.0) {
            return 2.5;
        }
        if (estimated < 500.0) {
            return 3.0;
        }
        if (estimated < 1000.0) {
            return 3.3;
        }
        if (estimated < 10000.0) {
            return 3.5;
        }
        if (estimated < 1000000.0) {
            return 4.5;
        }
        if (estimated < 1.0E7) {
            return 5.5;
        }
        return 6.0;
    }

    private static Double getNumberOfRows(Node op) {
        StringBuilder actual = new StringBuilder();
        op.getTransientNode("RunTimeInformation").flatMap(rt -> rt.getNode("RunTimeCountersPerThread")).map(rtt -> rtt.getAttributeValue("ActualRows")).ifPresent(actual::append);
        if (actual.length() > 0) {
            return Double.valueOf(actual.toString());
        }
        return null;
    }
}

