/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import java.util.Optional;

public class QueryPlanStats {
    private final Integer nodeId;
    private final Integer threadId;
    private final String physical_operator_name;
    private final Long estimate_row_count;
    private final Long row_count;
    private final Long open_time;
    private final Long close_time;
    private final Long elapsed_time_ms;

    public QueryPlanStats(Node node) {
        this.nodeId = this.getIntValue(node, "node_id");
        this.threadId = this.getIntValue(node, "thread_id");
        this.physical_operator_name = this.getValue(node, "physical_operator_name").orElse(null);
        this.estimate_row_count = this.getLongValue(node, "estimate_row_count");
        this.row_count = this.getLongValue(node, "row_count");
        this.open_time = this.getLongValue(node, "open_time");
        this.close_time = this.getLongValue(node, "close_time");
        this.elapsed_time_ms = this.getLongValue(node, "elapsed_time_ms");
    }

    private Integer getIntValue(Node n, String name) {
        return this.getValue(n, name).map(Integer::valueOf).orElse(null);
    }

    private Long getLongValue(Node n, String name) {
        return this.getValue(n, name).map(Long::valueOf).orElse(null);
    }

    private Optional<String> getValue(Node n, String name) {
        return n.getNode(name).map(Node::getValue);
    }

    public final Integer getNodeId() {
        return this.nodeId;
    }

    public final Integer getThreadId() {
        return this.threadId;
    }

    public final String getPhysical_operator_name() {
        return this.physical_operator_name;
    }

    public final Long getEstimate_row_count() {
        return this.estimate_row_count;
    }

    public final Long getRow_count() {
        return this.row_count;
    }

    public final Long getOpen_time() {
        return this.open_time;
    }

    public final Long getClose_time() {
        return this.close_time;
    }

    public final Long getElapsed_time_ms() {
        return this.elapsed_time_ms;
    }
}

