/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.sqlserver.queryplan.Attribute;
import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import com.sigge.filerunner.sql.sqlserver.queryplan.NodeEdge;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanBuilder;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanUtils;
import com.siggemannen.core.Tuple;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableComponentTip;

public final class QueryPlanGraph
extends mxGraph
implements Closeable {
    private FocusableComponentTip fc;
    private MouseEvent e;

    QueryPlanGraph(JComponent j) {
        this.fc = new FocusableComponentTip(j, null);
    }

    public void setEvent(MouseEvent e) {
        this.e = e;
    }

    public String convertValueToString(Object cell) {
        Object result = this.model.getValue(cell);
        QueryPlanBuilder.NodeItem nodeItem = null;
        if (result == null) {
            return "";
        }
        if (result instanceof NodeEdge) {
            return ((NodeEdge)result).getLabel();
        }
        if (result instanceof Tuple) {
            Object first = ((Tuple)result).first();
            Object second = ((Tuple)result).second();
            if (first instanceof Node) {
                result = first;
                nodeItem = (QueryPlanBuilder.NodeItem)second;
            }
        }
        if (!(result instanceof Node)) {
            String res = result.toString();
            if (res.split("\n").length < 5) {
                res = String.valueOf(res) + StringUtils.repeat("\n", 5 - res.split("\n").length);
            }
            return res;
        }
        Node n = (Node)result;
        String s = QueryPlanUtils.getInfoForRelOp(n);
        if (nodeItem != null) {
            s = String.valueOf(s) + nodeItem.getExtra();
        }
        if (s.split("\n").length < 5) {
            s = String.valueOf(s) + StringUtils.repeat("\n", 5 - s.split("\n").length);
        }
        return s;
    }

    public mxRectangle getPreferredSizeForCell(Object cell) {
        mxRectangle size = super.getPreferredSizeForCell(cell);
        if (!(cell instanceof NodeEdge)) {
            size.setHeight(34.0);
            size.setWidth(34.0);
        }
        return size;
    }

    public String getToolTipForCell(Object cell) {
        String s = this.getRealToolTip(cell);
        if (s == null) {
            this.fc.possiblyDisposeOfTipWindow();
        } else {
            this.fc.setImageBase(null);
            this.fc.toolTipRequested(this.e.getPoint(), s);
        }
        return null;
    }

    private String getRealToolTip(Object cell) {
        Object result = this.model.getValue(cell);
        if (result instanceof Tuple) {
            Tuple nodeTuple = (Tuple)result;
            result = nodeTuple.first();
        }
        if (!(result instanceof Node)) {
            return super.getToolTipForCell(cell);
        }
        Node n = (Node)result;
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        n.getTransientNode("RunTimeInformation").flatMap(rt -> rt.getNode("RunTimeCountersPerThread")).map(rValue -> rValue.getAttributes()).ifPresent(e -> e.stream().forEachOrdered(a -> {
            StringBuilder stringBuilder2 = sb.append("<b>").append(a.getName()).append("</b>").append(": ").append(a.getValue()).append("<br>");
        }));
        for (Attribute a : n.getAttributes()) {
            sb.append("<b>").append(a.getName()).append("</b>").append(": ").append(a.getValue()).append("<br>");
        }
        String physOp = n.getAttributeValue("PhysicalOp");
        if (physOp != null) {
            if (physOp.contains("Index Seek") || physOp.contains("Index Scan")) {
                physOp = "IndexScan";
            } else if (physOp.contains("Hash Match")) {
                n.getTraversalNode("Hash").getNode("ProbeResidual", "ScalarOperator").ifExists(so -> {
                    StringBuilder stringBuilder2 = sb.append("<br><b>ProbeResidual:</b><br>").append(QueryPlanGraph.escape(so.getAttributeValue("ScalarString")));
                });
            } else {
                physOp = physOp.replace(" ", "");
            }
            List preds = n.getTraversalNode(physOp).getNode("SeekPredicates").getNode().map(f -> f.getNodes("SeekPredicateNew")).orElse(Collections.EMPTY_LIST);
            StringBuilder sb2 = new StringBuilder();
            int counter = 0;
            for (Node predicate : preds) {
                if (++counter == 1) {
                    sb2.append("<br><b>Predicates:</b>");
                }
                if (preds.size() > 1) {
                    sb2.append("<br>[").append(counter).append("]:");
                }
                List<Node> seekKeys = predicate.getNodes("SeekKeys");
                for (Node seekNode : seekKeys) {
                    Optional<ScanRangeType> pfNode = this.getScanRangeType(seekNode.getNode("Prefix"));
                    Optional<ScanRangeType> startRangeNode = this.getScanRangeType(seekNode.getNode("StartRange"));
                    Optional<ScanRangeType> endRange = this.getScanRangeType(seekNode.getNode("EndRange"));
                    List isNotNull = seekNode.getNode("IsNotNull").map(mn -> mn.getNodes("ColumnReference")).orElse(Collections.EMPTY_LIST);
                    pfNode.ifPresent(p -> {
                        StringBuilder stringBuilder2 = sb2.append("<br><b>Prefix:</b><br>").append(p.toString());
                    });
                    startRangeNode.ifPresent(p -> {
                        StringBuilder stringBuilder2 = sb2.append("<br><b>Start: </b>").append(p.toString());
                    });
                    endRange.ifPresent(p -> {
                        StringBuilder stringBuilder2 = sb2.append("<br><b>End: </b>").append(p.toString());
                    });
                    if (isNotNull.size() <= 0) continue;
                    sb2.append("<br><b>Not nulls:</b><br>");
                    int i = 0;
                    while (i < isNotNull.size()) {
                        if (i > 0) {
                            sb2.append("<br>");
                        }
                        sb2.append(this.getTableAndColumn((Node)isNotNull.get(i)));
                        ++i;
                    }
                }
            }
            sb.append((CharSequence)sb2);
            n.getTraversalNode(physOp).getNode("Predicate", "ScalarOperator").ifExists(so -> {
                StringBuilder stringBuilder2 = sb.append("<br><b>Selection:</b><br>").append(QueryPlanGraph.escape(so.getAttributeValue("ScalarString")));
            });
        }
        ArrayList sort = new ArrayList();
        n.getTraversalNode("Sort").getNode("OrderBy").ifExists(no -> no.getNodes().forEach(nm -> {
            Optional<Node> col = nm.getNode("ColumnReference");
            if (col.isPresent() && nm.getName().equals("OrderByColumn")) {
                sort.add(col.get());
                if (sort.size() == 1) {
                    sb.append("<br><b>Sort: </b><br>");
                }
                sb.append("<b>Column: </b>").append(this.getTableAndColumn(col.get())).append("0".equals(nm.getAttributeValue("Ascending")) ? " DESC" : "").append("<br>");
            }
        }));
        ArrayList references = new ArrayList();
        n.getTransientNode("OutputList").ifPresent(nx -> {
            boolean bl = references.addAll(nx.getNodes().stream().filter(node -> node.getName().equals("ColumnReference")).collect(Collectors.toList()));
        });
        if (references.size() > 0) {
            sb.append("<br><b>Output list: </b><br>");
        }
        references.forEach(r -> {
            StringBuilder stringBuilder2 = sb.append("<b>Column").append(": </b>").append(this.getTableAndColumn((Node)r)).append("<br>");
        });
        sb.append("</html>");
        return sb.toString();
    }

    private Optional<ScanRangeType> getScanRangeType(Optional<Node> node) {
        if (!node.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new ScanRangeType(node.get()));
    }

    private static String escape(String value) {
        if (value == null) {
            return value;
        }
        return value.replace("<", "&lt;").replace(">", "&gt;");
    }

    private String getTableAndColumn(Node a) {
        String table = a.getAttributeValue("Table");
        table = table != null ? String.valueOf(QueryPlanUtils.unescape(table)) + "." : "";
        table = String.valueOf(table) + QueryPlanUtils.unescape(a.getAttributeValue("Column"));
        return table;
    }

    public boolean isCellConnectable(Object cell) {
        return false;
    }

    public boolean isCellDisconnectable(Object cell, Object terminal, boolean source) {
        return false;
    }

    public boolean isCellDeletable(Object cell) {
        return false;
    }

    public boolean isCellEditable(Object cell) {
        return false;
    }

    public void removeFocusableTip() {
        this.fc.possiblyDisposeOfTipWindow();
    }

    @Override
    public void close() throws IOException {
        this.fc.possiblyDisposeOfTipWindow();
        this.e = null;
        this.fc = null;
    }

    private class ScanRangeType {
        List<String> tableColumns = new ArrayList<String>();
        List<String> scalarOperator = new ArrayList<String>();
        String scanType;

        public ScanRangeType(Node scanRangeNode) {
            this.scanType = scanRangeNode.getAttributeValue("ScanType");
            List columns = scanRangeNode.getNode("RangeColumns").map(n -> n.getNodes("ColumnReference")).orElse(Collections.EMPTY_LIST);
            List exps = scanRangeNode.getNode("RangeExpressions").map(n -> n.getNodes("ScalarOperator")).orElse(Collections.EMPTY_LIST);
            for (Node n2 : columns) {
                String s = QueryPlanGraph.this.getTableAndColumn(n2);
                this.tableColumns.add(s);
            }
            for (Node n2 : exps) {
                this.scalarOperator.add(QueryPlanGraph.escape(n2.getAttributeValue("ScalarString")));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < Math.min(this.tableColumns.size(), this.scalarOperator.size())) {
                String tableColumn = this.tableColumns.get(i);
                String scalarOperators = this.scalarOperator.get(i);
                if (i > 0) {
                    sb.append(";");
                }
                sb.append(tableColumn).append(" ").append(QueryPlanGraph.escape(this.getScanType())).append(" ").append(scalarOperators);
                ++i;
            }
            return sb.toString();
        }

        private String getScanType() {
            if (this.scanType == null) {
                return "?";
            }
            switch (this.scanType) {
                case "EQ": {
                    return "=";
                }
                case "GE": {
                    return ">=";
                }
                case "LE": {
                    return "<=";
                }
                case "GT": {
                    return ">";
                }
                case "LT": {
                    return "<";
                }
            }
            return this.scanType;
        }
    }
}

