/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.mxgraph.layout.orthogonal.mxOrthogonalLayout;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.export.ExportResult;
import com.sigge.filerunner.export.raw.RawExportAction;
import com.sigge.filerunner.export.raw.RawSetting;
import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import com.sigge.filerunner.sql.sqlserver.queryplan.NodeEdge;
import com.sigge.filerunner.sql.sqlserver.queryplan.NodeViewer;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanGraph;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanStatHandler;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanStats;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanUtils;
import com.sigge.filerunner.sql.sqlserver.queryplan.XmlParser;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.QueryPlanPanel;
import com.sigge.filerunner.view.results.ResultTableHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.siggemannen.core.Tuple;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.VerticalLayout;

public class QueryPlanBuilder {
    private static final int LEFT_EDGE_X = 30;

    public List<QueryPlanPanel> buildGraph(String xml, Map<String, IResultSetTable> repo, String id, long counter) {
        return this.buildGraph(xml, true, repo, id, counter, null);
    }

    public List<QueryPlanPanel> buildGraph(String xml) {
        return this.buildGraph(xml, true, null);
    }

    public List<QueryPlanPanel> buildGraph(String xml, boolean addStatementText, Map<String, Object> data) {
        return this.buildGraph(xml, addStatementText, null, null, null, data);
    }

    private List<QueryPlanPanel> buildGraph(final String xml, boolean addStatementText, final Map<String, IResultSetTable> repo, final String id, final Long counter, Map<String, Object> data) {
        ArrayList<QueryPlanPanel> panels = new ArrayList<QueryPlanPanel>();
        XmlParser qp = new XmlParser();
        if (xml.startsWith("<LOCK_TIMEOUT")) {
            return panels;
        }
        Node n = qp.parse(xml, "ShowPlanXML");
        String sql = "";
        if (n == null) {
            return panels;
        }
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        String xmlStats = (String)data.get("PROGRESS_XML");
        ArrayList<QueryPlanStats> qps = new ArrayList<QueryPlanStats>();
        if (xmlStats != null) {
            for (Node nx : new XmlParser().parse(xmlStats, "progress").getNodes()) {
                qps.add(new QueryPlanStats(nx));
            }
        }
        QueryPlanStatHandler handler = new QueryPlanStatHandler(qps);
        List<Node> statements = this.findNodes(n, "StmtSimple");
        for (Node statement : statements) {
            QueryPlanPanel qpl = new QueryPlanPanel();
            qpl.setLayout(new BoxLayout(qpl, 3));
            final QueryPlanGraph mx = QueryPlanUtils.createQPGraph(qpl);
            qpl.setGraph(mx);
            mx.setBorder(0);
            mxGraphModel mxm = new mxGraphModel();
            mxm.beginUpdate();
            mx.setModel((mxIGraphModel)mxm);
            Node stmt = statement;
            sql = stmt.getAttributeValue("StatementText");
            String attributeValue = stmt.getAttributeValue("StatementType");
            Object x = mx.insertVertex(mx.getDefaultParent(), stmt.getAttributeValue("StatementId"), attributeValue, 30.0, 0.0, 30.0, 30.0, QueryPlanUtils.getStyleForNode(stmt));
            mx.updateCellSize(x);
            Node relOps = new Node("QP");
            this.buildRelOpNode(stmt, relOps);
            ArrayList<NodeItem> items = new ArrayList<NodeItem>();
            this.process(new NodeItem(statement, 0, 0, handler), items, 0, handler);
            this.compress(items);
            this.buildGraph(mx, relOps, x, items);
            mx.setAutoSizeCells(true);
            final mxGraphComponent comp = new mxGraphComponent(mx){

                protected mxGraphComponent.mxGraphControl createGraphControl() {
                    return new mxGraphComponent.mxGraphControl(this){

                        public String getToolTipText(MouseEvent event) {
                            mx.setEvent(event);
                            return super.getToolTipText(event);
                        }
                    };
                }
            };
            mxGraphComponent graphContainer = comp.getGraphControl().getGraphContainer();
            graphContainer.setHorizontalScrollBarPolicy(32);
            comp.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    IResultSetTable rs;
                    mx.removeFocusableTip();
                    if (!ButtonUtils.isRightClick(e)) {
                        return;
                    }
                    Object cell = comp.getCellAt(e.getX(), e.getY());
                    Object node = cell != null ? mx.getModel().getValue(cell) : null;
                    JPopupMenu jp = new JPopupMenu();
                    if (repo != null && (rs = (IResultSetTable)repo.get(id)) != null) {
                        jp.add(new JMenuItem(ActionUtils.createAction("Save query plan as file", () -> {
                            Optional<ExportResult> optional = ResultTableHandler.exportData(Arrays.asList(rs), false, new RawExportAction("Export", null){

                                @Override
                                public RawSetting getPreferences(List<IResultSetTable> model, boolean selectionOnly) {
                                    return new RawSetting(xml, "queryplan" + (counter != null ? "" + counter : "") + ".sqlplan", new FileNameExtensionFilter("SQL plans (*.sqlplan)", "sqlplan"), new FileNameExtensionFilter("XML (*.xml)", "xml"));
                                }
                            });
                        })));
                        jp.add(new JMenuItem(ActionUtils.createAction("Copy to clipboard", () -> ClipboardUtils.setStringDataToClipboard(xml))));
                    }
                    if (node != null) {
                        jp.add(new JMenuItem(ActionUtils.createAction("Properties...", () -> new NodeViewer().display(node))));
                    }
                    if (jp.getComponentCount() > 0) {
                        jp.show((Component)comp.getGraphControl(), e.getX(), e.getY());
                    }
                }
            });
            comp.setBorder(BorderFactory.createEmptyBorder());
            comp.setToolTips(true);
            mxm.endUpdate();
            mx.getModel().beginUpdate();
            mxOrthogonalLayout layout = new mxOrthogonalLayout((mxGraph)mx);
            try {
                layout.execute(mx.getDefaultParent());
            }
            finally {
                mx.getModel().endUpdate();
            }
            JPanel jp = new JPanel();
            jp.setLayout((LayoutManager)new VerticalLayout(10));
            if (addStatementText) {
                RSQLSyntaxTextArea rx = new RSQLSyntaxTextArea(sql, "text/tsql");
                RTextScrollPane rtxp = new RTextScrollPane((RTextArea)rx);
                rtxp.setViewportView((Component)((Object)rx));
                int rows = rx.getDocument().getDefaultRootElement().getElementCount();
                int height = 200;
                if (rows < 10) {
                    height = rx.getLineHeight() * rows + 30;
                }
                rtxp.setPreferredSize(new Dimension(200, height));
                TextPaneUtil.configureSyntaxTextArea(rx);
                rtxp.setLineNumbersEnabled(false);
                rtxp.setHorizontalScrollBarPolicy(30);
                rx.setEditable(false);
                jp.add((Component)rtxp);
            }
            jp.add((Component)comp);
            jp.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            qpl.add(jp);
            panels.add(qpl);
        }
        return panels;
    }

    private int process(NodeItem n, List<NodeItem> items, int maxHeight, QueryPlanStatHandler handler) {
        boolean first = true;
        for (Node nd : n.node.getNodes()) {
            if (nd.getName().equals("RelOp")) {
                maxHeight = (first ? 0 : 1) + maxHeight;
                NodeItem item = new NodeItem(nd, n.x + (first ? 1 : 0), maxHeight, handler);
                first = false;
                items.add(item);
                maxHeight = this.process(item, items, maxHeight, handler);
                continue;
            }
            maxHeight = this.process(new NodeItem(nd, n.x, n.y, handler), items, maxHeight, handler);
        }
        return maxHeight;
    }

    private void compress(List<NodeItem> items) {
        HashMap<Integer, Map> list = new HashMap<Integer, Map>();
        int maxLevel = 0;
        for (NodeItem item : items) {
            list.computeIfAbsent(item.x, k -> new HashMap()).computeIfAbsent(item.y, k -> item);
            if (maxLevel >= item.y) continue;
            maxLevel = item.y;
        }
        for (Integer k2 : list.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList())) {
            Map v = (Map)list.get(k2);
            for (Integer z : v.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList())) {
                NodeItem x = (NodeItem)v.remove(z);
                while (!(x.y <= 0 || list.get(x.x + 1) != null && ((Map)list.get(x.x + 1)).get(x.y) != null || v.get(x.y - 1) != null || list.get(x.x - 1) != null && ((Map)list.get(x.x - 1)).get(x.y) != null)) {
                    x.y = x.y - 1;
                }
                v.put(x.y, x);
            }
        }
        HashMap<Integer, List> levelItems = new HashMap<Integer, List>();
        for (NodeItem item : items) {
            levelItems.computeIfAbsent(item.y, k -> new ArrayList()).add(item);
        }
        int level = maxLevel;
        while (level > 0) {
            if (levelItems.get(level) == null) {
                int tmpLevel = level;
                while (++tmpLevel <= maxLevel) {
                    List ix = (List)levelItems.remove(tmpLevel);
                    if (ix == null) continue;
                    levelItems.put(tmpLevel - 1, ix);
                    ix.forEach(i -> {
                        int n = ((NodeItem)i).y - 1;
                        int n2 = n;
                        ((NodeItem)i).y = n;
                    });
                }
            }
            --level;
        }
    }

    private Node buildRelOpNode(Node parent, Node treeNode) {
        for (Node x : parent.getNodes()) {
            if (x.getName().equals("RelOp")) {
                Node copyWithAttributes = x.copyWithAttributes();
                treeNode.addNode(copyWithAttributes);
                this.buildRelOpNode(x, copyWithAttributes);
                continue;
            }
            this.buildRelOpNode(x, treeNode);
        }
        return treeNode;
    }

    private void buildGraph(mxGraph mx, Node parent, Object graphObject, List<NodeItem> items) {
        Node next = parent;
        Iterator<Node> iterator = next.getNodes().iterator();
        while (iterator.hasNext()) {
            Object x;
            Node nx;
            Node relOperation = nx = iterator.next();
            String attributeValue = relOperation.getAttributeValue("NodeId");
            Optional<NodeItem> z = items.stream().filter(i -> {
                Integer nodeId = Integer.valueOf(attributeValue);
                return Objects.equals(((NodeItem)i).nodeid, nodeId);
            }).findFirst();
            if (z.isPresent()) {
                NodeItem nd = z.get();
                x = mx.insertVertex(mx.getDefaultParent(), "NodeId" + attributeValue, (Object)Tuple.of((Object)relOperation, (Object)nd), (double)(30 + nd.x * 150), (double)(nd.y * 150), 30.0, 30.0, QueryPlanUtils.getStyleForNode(relOperation));
            } else {
                x = mx.insertVertex(mx.getDefaultParent(), "NodeId" + attributeValue, (Object)relOperation, 0.0, 0.0, 30.0, 30.0, QueryPlanUtils.getStyleForNode(relOperation));
            }
            mx.updateCellSize(x);
            mx.insertEdge(mx.getDefaultParent(), "RelOp" + attributeValue, (Object)new NodeEdge(QueryPlanUtils.getEdgeInfoForRelOp(relOperation), relOperation), x, graphObject, QueryPlanUtils.getStyleForEdge(relOperation));
            this.buildGraph(mx, relOperation, x, items);
        }
    }

    public static Optional<Node> findNode(Node n, String name) {
        if (n.getName().equalsIgnoreCase(name)) {
            return Optional.of(n);
        }
        for (Node node : n.getNodes()) {
            Optional<Node> nx = QueryPlanBuilder.findNode(node, name);
            if (!nx.isPresent()) continue;
            return nx;
        }
        return Optional.empty();
    }

    private List<Node> findNodes(Node n, String name) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (n.getName().equalsIgnoreCase(name)) {
            nodes.add(n);
        }
        for (Node node : n.getNodes()) {
            nodes.addAll(this.findNodes(node, name));
        }
        return nodes;
    }

    public static class NodeItem
    implements Serializable {
        private final int x;
        private int y;
        private final Node node;
        private int nodeid;
        private String extra;

        NodeItem(Node n, int x, int y, QueryPlanStatHandler handler) {
            this.node = n;
            this.x = x;
            this.y = y;
            String nodeId = this.node.getAttributeValue("NodeId");
            if (nodeId != null) {
                this.nodeid = Integer.valueOf(nodeId);
                this.extra = handler.getStatsFromId(this.nodeid);
            } else {
                this.nodeid = -1;
            }
        }

        public int hashCode() {
            return Integer.hashCode(this.nodeid);
        }

        public String toString() {
            return String.format("%d %d %s %s", this.x, this.y, QueryPlanUtils.getInfoForRelOp(this.node), this.extra);
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }
    }
}

