/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.steps;

import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerAgentProxy;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.StepAction;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.Subsystem;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.jobs.ICommand;
import com.sigge.filerunner.view.jobs.IJobStep;
import java.util.Arrays;
import java.util.List;

public class SQLServerJobStep
implements IJobStep {
    public static final int NEW_STEP = -1;
    private String jobId;
    private String stepId;
    private int stepNumber = -1;
    private String stepName;
    private Subsystem subsystem;
    private String command;
    private StepAction onSuccess = StepAction.GO_TO_NEXT_STEP;
    private StepAction onFailure = StepAction.QUIT_WITH_FAILURE;
    private String server;
    private String database;
    private String userName;
    private int retryAttempts;
    private int retryInterval;
    private boolean logToTable;
    private String outputFileName;
    private boolean overwriteFile;
    private boolean includeInStepHistory;
    private boolean writeToTable;
    private boolean overwriteToTable;
    private int stepNumberOriginal = -1;
    private int unsupportedflags = 0;
    private int cmdexec_success_code = 0;
    private TextListItem<Integer> fileLog;
    private TextListItem<Integer> historyLog;
    private TextListItem<Integer> stepHistoryLog;
    private SQLServerAgentProxy proxy;
    static final List<TextListItem<Integer>> FILE_LOG_LIST = Arrays.asList(new TextListItem<Integer>(0, "Don't log"), new TextListItem<Integer>(2, "Append to file"));
    static final List<TextListItem<Integer>> TABLE_LOG_LIST = Arrays.asList(new TextListItem<Integer>(0, "Only log step execution"), new TextListItem<Integer>(4, "Log some output"), new TextListItem<Integer>(32, "Log everything"));
    static final List<TextListItem<Integer>> STEP_LOG_LIST = Arrays.asList(new TextListItem<Integer>(0, "Don't log"), new TextListItem<Integer>(8, "Overwrite each run"), new TextListItem<Integer>(16, "Append"));

    public SQLServerJobStep() {
        this.setFileLog(FILE_LOG_LIST.get(0));
        this.setHistoryLog(TABLE_LOG_LIST.get(0));
        this.setStepHistoryLog(STEP_LOG_LIST.get(0));
        this.proxy = SQLServerAgentProxy.DEFAULT_PROXY;
    }

    public int getFlags() {
        return this.unsupportedflags + this.fileLog.getValue() + this.historyLog.getValue() + this.stepHistoryLog.getValue();
    }

    public void setFlags(int flags) {
        this.fileLog = FILE_LOG_LIST.get((flags & 2) == 2 ? 1 : 0);
        this.historyLog = TABLE_LOG_LIST.get((flags & 4) == 4 ? 1 : ((flags & 0x20) == 32 ? 2 : 0));
        this.stepHistoryLog = STEP_LOG_LIST.get((flags & 8) == 8 ? 1 : ((flags & 0x10) == 16 ? 2 : 0));
        this.overwriteFile = (flags & 2) == 2;
        this.includeInStepHistory = (flags & 4) == 4;
        this.writeToTable = (flags & 8) == 8;
        this.overwriteToTable = (flags & 0x10) == 16;
        this.unsupportedflags = flags & 0xFFFFFFC1;
    }

    public boolean normalize() {
        if (this.subsystem == null) {
            return false;
        }
        switch (this.subsystem.getName()) {
            case "TSQL": {
                this.server = null;
                this.proxy = null;
                break;
            }
            case "ANALYSISCOMMAND": {
                this.database = null;
                break;
            }
            case "CmdExec": {
                this.server = null;
                this.database = null;
                break;
            }
            case "Distribution": {
                this.server = null;
                this.database = null;
                this.outputFileName = null;
                this.fileLog = FILE_LOG_LIST.get(0);
                this.stepHistoryLog = STEP_LOG_LIST.get(0);
                break;
            }
            case "LogReader": {
                this.server = null;
                this.database = null;
                this.outputFileName = null;
                this.fileLog = FILE_LOG_LIST.get(0);
                this.stepHistoryLog = STEP_LOG_LIST.get(0);
                break;
            }
            case "Merge": {
                this.server = null;
                this.database = null;
                this.outputFileName = null;
                this.fileLog = FILE_LOG_LIST.get(0);
                this.stepHistoryLog = STEP_LOG_LIST.get(0);
                break;
            }
            case "PowerShell": {
                this.server = null;
                this.database = null;
                break;
            }
            case "QueueReader": {
                this.server = null;
                this.outputFileName = null;
                this.fileLog = FILE_LOG_LIST.get(0);
                this.stepHistoryLog = STEP_LOG_LIST.get(0);
                break;
            }
            case "Snapshot": {
                this.server = null;
                this.database = null;
                this.outputFileName = null;
                this.fileLog = FILE_LOG_LIST.get(0);
                this.stepHistoryLog = STEP_LOG_LIST.get(0);
                break;
            }
            case "SSIS": {
                this.server = null;
                this.database = null;
                break;
            }
            default: {
                this.server = null;
                this.database = null;
                if (this.historyLog.getValue() == null || !this.historyLog.getValue().equals(4)) break;
                this.stepHistoryLog = TABLE_LOG_LIST.get(0);
            }
            case "ANALYSISQUERY": 
        }
        return true;
    }

    public boolean isNew() {
        return this.stepNumber == -1;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setStepNumber(int stepNumber) {
        this.stepNumber = stepNumber;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public Subsystem getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(Subsystem subsystem) {
        this.subsystem = subsystem;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public StepAction getOnSuccess() {
        return this.onSuccess;
    }

    public void setOnSuccess(StepAction onSuccess) {
        this.onSuccess = onSuccess;
    }

    public StepAction getOnFailure() {
        return this.onFailure;
    }

    public void setOnFailure(StepAction onFailure) {
        this.onFailure = onFailure;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public boolean isLogToTable() {
        return this.logToTable;
    }

    public void setLogToTable(boolean logToTable) {
        this.logToTable = logToTable;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public boolean isOverwriteFile() {
        return this.overwriteFile;
    }

    public void setOverwriteFile(boolean overwriteFile) {
        this.overwriteFile = overwriteFile;
    }

    public boolean isIncludeInStepHistory() {
        return this.includeInStepHistory;
    }

    public void setIncludeInStepHistory(boolean includeInStepHistory) {
        this.includeInStepHistory = includeInStepHistory;
    }

    public boolean isOverwriteToTable() {
        return this.overwriteToTable;
    }

    public void setOverwriteToTable(boolean overwriteToTable) {
        this.overwriteToTable = overwriteToTable;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void execute(ICommand command) {
    }

    @Override
    public boolean supports(ICommand command) {
        return false;
    }

    @Override
    public int getNumber() {
        return this.stepNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.stepNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLServerJobStep other = (SQLServerJobStep)obj;
        return this.stepNumber == other.stepNumber;
    }

    public int getStepNumberOriginal() {
        return this.stepNumberOriginal;
    }

    public void setStepNumberOriginal(int stepNumberOriginal) {
        this.stepNumberOriginal = stepNumberOriginal;
    }

    public int getCmdexec_success_code() {
        return this.cmdexec_success_code;
    }

    public void setCmdexec_success_code(int cmdexec_success_code) {
        this.cmdexec_success_code = cmdexec_success_code;
    }

    public TextListItem<Integer> getFileLog() {
        return this.fileLog;
    }

    public void setFileLog(TextListItem<Integer> fileLog) {
        this.fileLog = fileLog;
    }

    public TextListItem<Integer> getHistoryLog() {
        return this.historyLog;
    }

    public void setHistoryLog(TextListItem<Integer> historyLog) {
        this.historyLog = historyLog;
    }

    public TextListItem<Integer> getStepHistoryLog() {
        return this.stepHistoryLog;
    }

    public void setStepHistoryLog(TextListItem<Integer> stepHistoryLog) {
        this.stepHistoryLog = stepHistoryLog;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public SQLServerAgentProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(SQLServerAgentProxy proxy) {
        this.proxy = proxy;
    }
}

