/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.schedule.view;

import com.sigge.filerunner.sql.sqlserver.jobs.schedule.IScheduleBinder;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.TimePeriod;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.WeeklySchedule;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ValueHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WeeklySchedulePanel
extends JPanel
implements IScheduleBinder {
    private Binder.Presenter<List<TimePeriod>> listOfCheckBoxDays;
    private Binder.Presenter<Comparable> timePresenter;
    private SQLServerSchedule schedule;

    public WeeklySchedulePanel(Window frame) {
        super(new BorderLayout());
        List<TimePeriod> listOfDays = Arrays.asList(TimePeriod.MONDAY, TimePeriod.TUESDAY, TimePeriod.WEDNESDAY, TimePeriod.THURSDAY, TimePeriod.FRIDAY, TimePeriod.SATURDAY, TimePeriod.SUNDAY);
        JPanel subTypeWeeklyInner1 = new JPanel();
        this.add((Component)subTypeWeeklyInner1, "North");
        subTypeWeeklyInner1.setLayout(new FlowLayout(0));
        subTypeWeeklyInner1.add(new JLabel("On: "));
        JComboBox timePeriodCombo = new JComboBox();
        subTypeWeeklyInner1.add(timePeriodCombo);
        this.timePresenter = Binder.bindToCombo(timePeriodCombo, Arrays.asList(new Comparable[]{TimePeriod.MONDAY, TimePeriod.TUESDAY, TimePeriod.WEDNESDAY, TimePeriod.THURSDAY, TimePeriod.FRIDAY, TimePeriod.MONDAY_TO_FRIDAY, TimePeriod.SATURDAY_SUNDAY, TimePeriod.SATURDAY, TimePeriod.SUNDAY, "Specific days..."}));
        JPanel checkboxesForWeek = new JPanel(new FlowLayout());
        ArrayList checkBoxes = new ArrayList();
        listOfDays.forEach(f -> {
            JCheckBox jc = new JCheckBox(f.toString());
            checkBoxes.add(jc);
            checkboxesForWeek.add(jc);
        });
        this.listOfCheckBoxDays = Binder.bindToCheckboxes(checkBoxes, listOfDays, listOfDays);
        this.timePresenter.addValueChangedListener(v -> {
            this.remove(checkboxesForWeek);
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().getWeeklySchedule().setTimePeriod((Comparable)v);
            }
            if (this.timePresenter.getValue() instanceof String) {
                this.add((Component)checkboxesForWeek, "South");
            }
            this.revalidate();
            frame.pack();
        }, true);
    }

    @Override
    public void bind(SQLServerSchedule initial) {
        this.schedule = initial;
        WeeklySchedule weekly = initial.getRecurringSchedule().getWeeklySchedule();
        if (weekly == null) {
            weekly = new WeeklySchedule();
            initial.getRecurringSchedule().setWeeklySchedule(weekly);
            weekly.setTimePeriod((Comparable)((Object)TimePeriod.MONDAY));
        }
        this.timePresenter.setObject((Object)new ValueHolder((Object)weekly.getTimePeriod()));
        this.listOfCheckBoxDays.setObject((Object)new ValueHolder(weekly.getWeekDays()));
    }
}

