/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.schedule.view;

import com.sigge.filerunner.sql.sqlserver.jobs.schedule.DailySchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.IScheduleBinder;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RecurringSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.ScheduleType;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.view.DailySchedulePanel;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.view.MonthlySchedulePanel;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.view.TypeOfDailyRecurringPanel;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.view.WeeklySchedulePanel;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ValueHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class RecurringSchedulePanel
extends JPanel
implements IScheduleBinder {
    private JComboBox<ScheduleType> scheduleType;
    private JSpinner spinner;
    private JPanel subTypePanel;
    private Binder.Presenter<ScheduleType> scheduleBinder;
    private Binder.Presenter<Integer> spinnerBinder;
    private SQLServerSchedule sqlServerSchedule;
    private TypeOfDailyRecurringPanel typeOfDailyMainPanel;

    public RecurringSchedulePanel(Window jd) {
        super(new BorderLayout());
        JPanel runScheduleRedPanel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel("Run schedule every: ");
        runScheduleRedPanel.add(label);
        this.spinner = new JSpinner();
        runScheduleRedPanel.add(this.spinner);
        runScheduleRedPanel.add(new JLabel(" nth"));
        this.scheduleType = new JComboBox();
        runScheduleRedPanel.add(this.scheduleType);
        this.add((Component)runScheduleRedPanel, "North");
        this.subTypePanel = new JPanel(new FlowLayout(0));
        this.add((Component)this.subTypePanel, "Center");
        WeeklySchedulePanel subtypeWeekly = new WeeklySchedulePanel(jd);
        MonthlySchedulePanel monthlysubType = new MonthlySchedulePanel();
        DailySchedulePanel dailyType = new DailySchedulePanel();
        this.scheduleBinder = Binder.bindToCombo(this.scheduleType, Arrays.asList(ScheduleType.DAY, ScheduleType.WEEK, ScheduleType.MONTH)).addValueChangedListener(s -> {
            this.getSubTypePanel().removeAll();
            if (this.sqlServerSchedule != null) {
                this.sqlServerSchedule.getRecurringSchedule().setScheduleType((ScheduleType)((Object)s));
            }
            switch (s) {
                case DAY: {
                    this.getSubTypePanel().add(dailyType);
                    dailyType.bind(this.sqlServerSchedule);
                    break;
                }
                case MONTH: {
                    this.getSubTypePanel().add(monthlysubType);
                    monthlysubType.bind(this.sqlServerSchedule);
                    break;
                }
                case WEEK: {
                    this.getSubTypePanel().add(subtypeWeekly);
                    subtypeWeekly.bind(this.sqlServerSchedule);
                    break;
                }
            }
            this.getSubTypePanel().revalidate();
            this.getSubTypePanel().getParent().revalidate();
            jd.pack();
        }, true);
        this.spinnerBinder = Binder.genericBind((Object)this.spinner, (ap, prop) -> {
            ap.bind(this.spinner).to(prop, null, Integer.valueOf(1), Integer.valueOf(1));
            if (this.sqlServerSchedule != null) {
                this.sqlServerSchedule.getRecurringSchedule().setEveryNth((Integer)prop.getValue());
            }
        }, (Object)1);
        this.typeOfDailyMainPanel = new TypeOfDailyRecurringPanel();
        this.add((Component)this.typeOfDailyMainPanel, "South");
    }

    public JComboBox<ScheduleType> getScheduleType() {
        return this.scheduleType;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    public JPanel getSubTypePanel() {
        return this.subTypePanel;
    }

    @Override
    public void bind(SQLServerSchedule initial) {
        this.sqlServerSchedule = initial;
        if (this.sqlServerSchedule == null) {
            return;
        }
        RecurringSchedule recurringSchedule = initial.getRecurringSchedule();
        if (recurringSchedule == null) {
            recurringSchedule = new RecurringSchedule();
            initial.setRecurringSchedule(recurringSchedule);
        }
        if (recurringSchedule.getScheduleType() == null) {
            recurringSchedule.setScheduleType(ScheduleType.DAY);
            recurringSchedule.setDailySchedule(new DailySchedule());
        }
        this.scheduleBinder.setObject((Object)new ValueHolder((Object)recurringSchedule.getScheduleType()));
        this.spinnerBinder.setObject((Object)new ValueHolder((Object)recurringSchedule.getEveryNth()));
        this.typeOfDailyMainPanel.bind(this.sqlServerSchedule);
    }
}

