/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.schedule;

import com.sigge.filerunner.core.ICopyable;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.TimePeriod;
import java.util.ArrayList;
import java.util.List;

public class WeeklySchedule
implements ICopyable<WeeklySchedule> {
    public static final String SPECIFIC_DAYS = "Specific days...";
    private final List<TimePeriod> weekDays = new ArrayList<TimePeriod>();
    private Comparable timePeriod;

    @Override
    public WeeklySchedule createCopy() {
        WeeklySchedule schedule = new WeeklySchedule();
        schedule.weekDays.addAll(this.weekDays);
        schedule.timePeriod = this.timePeriod;
        return schedule;
    }

    public List<TimePeriod> getWeekDays() {
        return this.weekDays;
    }

    public Comparable getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(Comparable timePeriod) {
        this.timePeriod = timePeriod;
    }

    int getFreqInterval() {
        if (this.timePeriod == null) {
            return 0;
        }
        if (this.timePeriod instanceof String) {
            int t = 0;
            for (TimePeriod tp : this.weekDays) {
                t += this.getFromTimePeriod(tp);
            }
            return t;
        }
        return this.getFromTimePeriod((TimePeriod)((Object)this.timePeriod));
    }

    public void setFromFreq_interval(int freq_interval) {
        ArrayList<TimePeriod> tp = new ArrayList<TimePeriod>();
        int weekdays = 0;
        int weekend = 0;
        if ((freq_interval & 1) == 1) {
            tp.add(TimePeriod.SUNDAY);
            ++weekend;
        }
        if ((freq_interval & 2) == 2) {
            tp.add(TimePeriod.MONDAY);
            ++weekdays;
        }
        if ((freq_interval & 4) == 4) {
            tp.add(TimePeriod.TUESDAY);
            ++weekdays;
        }
        if ((freq_interval & 8) == 8) {
            tp.add(TimePeriod.WEDNESDAY);
            ++weekdays;
        }
        if ((freq_interval & 0x10) == 16) {
            tp.add(TimePeriod.THURSDAY);
            ++weekdays;
        }
        if ((freq_interval & 0x20) == 32) {
            tp.add(TimePeriod.FRIDAY);
            ++weekdays;
        }
        if ((freq_interval & 0x40) == 64) {
            tp.add(TimePeriod.SATURDAY);
            ++weekend;
        }
        this.timePeriod = weekdays + weekend == 1 ? (Comparable)tp.get(0) : (weekdays * weekend == 0 ? (weekdays > 0 ? (weekdays == 5 ? TimePeriod.MONDAY_TO_FRIDAY : SPECIFIC_DAYS) : (weekend == 2 ? TimePeriod.SATURDAY_SUNDAY : SPECIFIC_DAYS)) : SPECIFIC_DAYS);
        this.weekDays.addAll(tp);
    }

    public int getFromTimePeriod(TimePeriod tp) {
        int number = 0;
        switch (tp) {
            case SUNDAY: {
                ++number;
                break;
            }
            case MONDAY: {
                number += 2;
                break;
            }
            case TUESDAY: {
                number += 4;
                break;
            }
            case WEDNESDAY: {
                number += 8;
                break;
            }
            case THURSDAY: {
                number += 16;
                break;
            }
            case FRIDAY: {
                number += 32;
                break;
            }
            case SATURDAY: {
                number += 64;
            }
            case MONDAY_TO_FRIDAY: {
                number += 62;
                break;
            }
            case SATURDAY_SUNDAY: {
                number += 65;
                break;
            }
        }
        return number;
    }
}

