/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.core.IFeedback;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.sqlserver.jobs.JobStore;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLJobServerStorage;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerAgentJobServer;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerAgentJobView;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.core.DatabaseCellRenderer;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.IJobServerManager;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.view.UIBackgroundRunner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SQLServerJobManager
implements IJobServerManager {
    private final RunnerModel model;
    private final DatabaseManager manager;
    private static final String FILENAME = "db/sqljobs.json";
    private JobStore jobStore;
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerJobManager.class);
    private final List<IJobServer> jobservers = new ArrayList<IJobServer>();
    private int maxId = 0;
    private final IFeedback feedback;

    @Inject
    public SQLServerJobManager(RunnerModel model, DatabaseManager manager, IFeedback feedback) {
        this.model = model;
        this.manager = manager;
        this.feedback = feedback;
    }

    @Override
    public IJobServer addJobServer(JPanel mainContainer) {
        this.loadSettings();
        SQLServerAgentJobView view = new SQLServerAgentJobView();
        mainContainer.add((Component)view, "Center");
        mainContainer.revalidate();
        Container c = mainContainer.getTopLevelAncestor();
        if (c instanceof Window) {
            ((Window)c).pack();
        }
        final ArrayList<DatabaseFromConfig> configs = new ArrayList<DatabaseFromConfig>();
        for (RunnerServerConfig db : (List)this.model.getServers().getValue()) {
            if (!db.getDatabaseProvider().equals(SQLServerDatabase.PROVIDER_NAME)) continue;
            try {
                DatabaseFromConfig dbx = this.manager.generateServer(db);
                if (dbx == null) continue;
                configs.add(dbx);
            }
            catch (Exception dbx) {
                // empty catch block
            }
        }
        SQLServerAgentJobModel model = new SQLServerAgentJobModel();
        APresenter<SQLServerAgentJobServer, SQLServerAgentJobModel, SQLServerAgentJobView> presenter = new APresenter<SQLServerAgentJobServer, SQLServerAgentJobModel, SQLServerAgentJobView>(model, view){

            protected void initBindings() {
                this.bind(((SQLServerAgentJobView)this.view).serverList).to(configs, ((SQLServerAgentJobModel)this.model).serverDatabase);
                this.bind(((SQLServerAgentJobView)this.view).jobNameTextField).to(((SQLServerAgentJobModel)this.model).name);
            }
        };
        SQLServerAgentJobServer server = new SQLServerAgentJobServer(this, this.feedback);
        presenter.setObject((Object)server);
        view.serverList.setRenderer(new DatabaseCellRenderer());
        DefaultListModel aModel = new DefaultListModel();
        view.jobListList.setModel(aModel);
        view.jobListList.setCellRenderer((ListCellRenderer)new LabelledCellRenderer(true));
        view.listJobsButton.addActionListener(al -> {
            if (server.getServerDatabase() != null) {
                aModel.removeAllElements();
                UIBackgroundRunner.execute(() -> server.getJobs(l -> SwingUtilities.invokeLater(() -> l.forEach(aModel::addElement))));
            }
        });
        return server;
    }

    private DatabaseFromConfig fromId(int id) {
        for (RunnerServerConfig db : (List)this.model.getServers().getValue()) {
            if (!db.getDatabaseProvider().equals(SQLServerDatabase.PROVIDER_NAME) || db.getId() != id) continue;
            try {
                DatabaseFromConfig dbx = this.manager.generateServer(db);
                if (dbx == null) continue;
                return dbx;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean save(IJobServer save) {
        SQLServerAgentJobServer server = (SQLServerAgentJobServer)save;
        if (server.getServerDatabase() == null) {
            return false;
        }
        if (StringUtils.isEmpty(server.getName())) {
            server.setName(server.getServerDatabase().getLabel());
        }
        if (server.getId() != null) {
            int indexOf = this.jobservers.indexOf(server);
            if (indexOf >= 0) {
                this.jobservers.set(indexOf, server);
            } else {
                this.jobservers.add(server);
            }
        } else {
            ++this.maxId;
            server.setId(String.valueOf(SQLServerDatabase.PROVIDER_NAME) + "_" + this.maxId);
            this.jobservers.add(server);
        }
        this.save();
        return true;
    }

    @Override
    public void edit(IJobServer server, JPanel mainContainer) {
    }

    private synchronized void loadSettings() {
        if (this.jobStore != null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FILENAME), "UTF-8");){
                this.jobStore = (JobStore)GsonFactory.forReading().fromJson((Reader)reader, JobStore.class);
                if (this.jobStore != null) {
                    List<SQLJobServerStorage> jobs = this.jobStore.getJobs();
                    int i = 0;
                    while (i < jobs.size()) {
                        SQLJobServerStorage s = jobs.get(i);
                        SQLServerAgentJobServer jobServer = new SQLServerAgentJobServer(this, this.feedback);
                        jobServer.setEnabled(true);
                        jobServer.setName(s.getName());
                        jobServer.setId(String.valueOf(SQLServerDatabase.PROVIDER_NAME) + "_" + (i + 1));
                        DatabaseFromConfig db = this.fromId(s.getDatabaseServerId());
                        if (db != null) {
                            jobServer.setServerDatabase(db);
                            this.jobservers.add(jobServer);
                            this.maxId = i + 1;
                        }
                        ++i;
                    }
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonSyntaxException jsonE) {
            LOGGER.error("Couldn't load config file", (Throwable)jsonE);
        }
        catch (FileNotFoundException jsonE) {
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't load config file", (Throwable)ex);
        }
        this.jobStore = new JobStore();
    }

    @Override
    public List<IJobServer> load() {
        this.loadSettings();
        return this.jobservers;
    }

    private void save() {
        ArrayList<SQLJobServerStorage> storage = new ArrayList<SQLJobServerStorage>();
        for (IJobServer server : this.jobservers) {
            storage.add(SQLJobServerStorage.fromJobServer((SQLServerAgentJobServer)server));
        }
        this.jobStore.setJobs(storage);
        GsonFactory.write(FILENAME, this.jobStore);
    }

    @Override
    public String getIcon() {
        return "MSSQL_16.png";
    }

    @Override
    public String getLabel() {
        return "SQL Server Agent";
    }

    @Override
    public void delete(IJobServer server) {
        if (this.jobservers.remove(server)) {
            this.save();
        }
    }

    @Override
    public void cleanup() {
        ArrayList<IJobServer> copy = new ArrayList<IJobServer>(this.jobservers);
        this.jobservers.clear();
        this.jobStore = null;
        new BackgroundRunner(() -> {
            int i = 0;
            while (i < copy.size()) {
                IJobServer j = (IJobServer)copy.get(i);
                j.cleanup();
                ++i;
            }
        }, ex -> {}).execute();
    }

    private static class SQLServerAgentJobModel
    extends AModel<SQLServerAgentJobServer> {
        IProperty<Database> serverDatabase = this.getProperty("serverDatabase");
        IProperty<String> name = this.getProperty("name");
        IProperty<Boolean> enabled = this.getProperty("enabled");
        IProperty<String> id = this.getProperty("id");

        private SQLServerAgentJobModel() {
        }
    }
}

