/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs;

import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerAgentJobServer;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJobHistory;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerJobStep;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.StepAction;
import com.sigge.filerunner.view.jobs.ICommand;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobHistory;
import com.sigge.filerunner.view.jobs.IJobSchedule;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.IJobStep;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class SQLServerJob
implements IJob {
    private final SQLServerAgentJobServer server;
    private String name;
    private boolean enabled;
    private String id;
    private String nativeId;
    private int startStepId = 1;
    private final List<IJobStep> jobSteps = new ArrayList<IJobStep>();
    private final List<SQLServerJobStep> jobStepsRemoved = new ArrayList<SQLServerJobStep>();
    private final List<IJobSchedule> schedules = new ArrayList<IJobSchedule>();
    private final List<SQLServerSchedule> schedules_removed = new ArrayList<SQLServerSchedule>();
    private SQLServerJobHistory lastRun;

    public SQLServerJob(SQLServerAgentJobServer server) {
        this.server = server;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void execute(ICommand command) {
    }

    @Override
    public boolean supports(ICommand command) {
        return false;
    }

    @Override
    public List<IJobStep> getSteps() {
        return this.jobSteps;
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    @Override
    public List<IJobSchedule> getSchedules() {
        return this.schedules;
    }

    @Override
    public IJobServer getJobServer() {
        return this.server;
    }

    @Override
    public Optional<IJobHistory> getLastRun() {
        return Optional.ofNullable(this.lastRun);
    }

    public void setLastRun(SQLServerJobHistory lastRun) {
        this.lastRun = lastRun;
    }

    @Override
    public void getJobHistory(Consumer<List<IJobHistory>> jobHistory) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLServerJob other = (SQLServerJob)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getNativeId() {
        return this.nativeId;
    }

    public void setNativeId(String nativeId) {
        this.nativeId = nativeId;
    }

    public String toString() {
        return "Job: " + this.name + ", server: " + this.server;
    }

    public void addStep(SQLServerJobStep step) {
        if (step.isNew()) {
            step.setStepNumber(this.getNewStepNumber());
            this.jobSteps.add(step);
            step.setJobId(this.nativeId);
        }
    }

    public void deleteSchedule(SQLServerSchedule schedule) {
        int i = this.schedules.size() - 1;
        while (i >= 0) {
            SQLServerSchedule ss = (SQLServerSchedule)this.schedules.get(i);
            if (ss.equals(schedule)) {
                this.schedules.remove(i);
                if (ss.getScheduleGUID() != null) {
                    this.schedules_removed.add(ss);
                }
            }
            --i;
        }
    }

    public List<SQLServerSchedule> getSchedules_removed() {
        return this.schedules_removed;
    }

    public void deleteStep(SQLServerJobStep step) {
        int i = this.jobSteps.size() - 1;
        while (i >= 0) {
            SQLServerJobStep ss = (SQLServerJobStep)this.jobSteps.get(i);
            if (ss.equals(step)) {
                this.jobSteps.remove(i);
                if (ss.getStepId() != null) {
                    this.jobStepsRemoved.add(ss);
                }
            }
            --i;
        }
    }

    private int getNewStepNumber() {
        int maxStepId = -1;
        int i = 0;
        while (i < this.jobSteps.size()) {
            SQLServerJobStep jobStep = (SQLServerJobStep)this.jobSteps.get(i);
            if (jobStep.getStepNumber() > maxStepId) {
                maxStepId = jobStep.getStepNumber();
            }
            ++i;
        }
        if (++maxStepId <= 0) {
            maxStepId = 1;
        }
        return maxStepId;
    }

    public void moveUp(SQLServerJobStep step) {
    }

    public void moveDown(SQLServerJobStep step) {
    }

    public List<StepAction> getActionsForStep(SQLServerJobStep step) {
        ArrayList<StepAction> actions = new ArrayList<StepAction>();
        actions.add(StepAction.GO_TO_NEXT_STEP);
        actions.add(StepAction.QUIT_WITH_SUCCESS);
        actions.add(StepAction.QUIT_WITH_FAILURE);
        ArrayList<Integer> steps = new ArrayList<Integer>();
        for (IJobStep jobStep : this.getSteps()) {
            SQLServerJobStep sqlstep = (SQLServerJobStep)jobStep;
            if (sqlstep.getStepNumber() == step.getStepNumber()) continue;
            steps.add(sqlstep.getStepNumber());
        }
        steps.sort(Comparator.naturalOrder());
        steps.forEach(e -> {
            boolean bl = actions.add(new StepAction((int)e));
        });
        return actions;
    }

    public int getStartStepId() {
        return this.startStepId;
    }

    public void setStartStepId(int startStepId) {
        this.startStepId = startStepId;
    }

    public boolean isStepRemapped() {
        for (IJobStep step : this.jobSteps) {
            SQLServerJobStep sstep = (SQLServerJobStep)step;
            if (sstep.getStepNumberOriginal() <= -1 || sstep.getStepNumber() == sstep.getStepNumberOriginal()) continue;
            return true;
        }
        return false;
    }

    public List<SQLServerJobStep> getJobStepsRemoved() {
        return this.jobStepsRemoved;
    }
}

