/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.sqlserver.ColumnFrom;
import com.sigge.filerunner.sql.transform.dml.SelectColumn;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.OrderByClauseExpression;
import com.sigge.filerunner.sql.transform.expression.SearchConditionNot;
import com.sigge.filerunner.sql.transform.select.source.ColumnAlias;
import com.sigge.filerunner.sql.transform.select.source.Source;
import com.sigge.filerunner.sql.transform.select.source.join.JoinExpression;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;

public class SelectColumnsHolder {
    int selectListFrom;
    int selectListTo;
    int whereListFrom;
    int whereListTo;
    int groupListFrom;
    int groupListTo;
    int havingListFrom;
    int havingListTo;
    int orderByListFrom;
    int orderByListTo;
    ParserRuleContext context;
    JoinExpression join;
    private SelectColumnsHolder parent;
    private SelectColumnsHolder prev;
    List<SelectColumn> cols = new ArrayList<SelectColumn>();
    private final List<SelectColumnsHolder> froms = new ArrayList<SelectColumnsHolder>();
    List<ColumnAlias> tableSourceColumnAliases = new ArrayList<ColumnAlias>();
    String name;
    String alias;
    String fullName;
    Source source;
    private boolean cte;
    private SearchConditionNot having;
    private SearchConditionNot where;
    private List<Expression> groupBy;
    private OrderByClauseExpression orderBy;
    private final List<SelectColumnsHolder> unions = new ArrayList<SelectColumnsHolder>();

    public List<SelectColumnsHolder> getFroms() {
        return this.froms;
    }

    public List<SelectColumn> getCols() {
        return this.cols;
    }

    public static List<ColumnFrom> getColumns(SelectColumnsHolder holder, List<ColumnFrom> cols) {
        ColumnFrom cf;
        ArrayList<ColumnFrom> cols2 = new ArrayList<ColumnFrom>();
        if (holder.tableSourceColumnAliases.size() > 0) {
            for (ColumnAlias x : holder.tableSourceColumnAliases) {
                if (x.getName() == null) continue;
                cf = new ColumnFrom();
                cf.setColumn(new SelectColumn(x.getName()));
                cf.holder = holder;
                cols.add(cf);
            }
            cols = cols2;
        }
        for (SelectColumn sl : holder.getCols()) {
            cf = new ColumnFrom();
            cf.setColumn(sl);
            cf.holder = holder;
            cols.add(cf);
        }
        return cols2;
    }

    public String getName() {
        return this.name;
    }

    public void addFrom(SelectColumnsHolder holder) {
        this.froms.add(holder);
        if (this.froms.size() > 1) {
            holder.prev = this.froms.get(this.froms.size() - 2);
        }
        holder.parent = this;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getSelectListFrom() {
        return this.selectListFrom;
    }

    public int getSelectListTo() {
        return this.selectListTo;
    }

    public int getWhereListFrom() {
        return this.whereListFrom;
    }

    public int getWhereListTo() {
        return this.whereListTo;
    }

    public int getGroupListFrom() {
        return this.groupListFrom;
    }

    public int getGroupListTo() {
        return this.groupListTo;
    }

    public int getOrderByListFrom() {
        return this.orderByListFrom;
    }

    public int getOrderByListTo() {
        return this.orderByListTo;
    }

    public int getHavingListTo() {
        return this.havingListTo;
    }

    public int getHavingListFrom() {
        return this.havingListFrom;
    }

    public void printHolder() {
        SelectColumnsHolder.printHolder(this, 1);
    }

    public static void printHolder(SelectColumnsHolder holder) {
        SelectColumnsHolder.printHolder(holder, 1);
    }

    private static void printHolder(SelectColumnsHolder holder, int level) {
        System.out.print(StringUtils.repeat("  ", level + 1));
        if (holder == null) {
            System.out.println("NULL");
            return;
        }
        System.out.print(holder.getFroms() + ", " + holder.getName() + ", AS " + holder.getAlias() + ", ");
        if (holder.getContext() != null) {
            System.out.print(holder.getContext().start);
            System.out.print(" - ");
            System.out.print(holder.getContext().stop);
        }
        System.out.println();
        for (SelectColumnsHolder h : holder.getFroms()) {
            SelectColumnsHolder.printHolder(h, level + 1);
        }
    }

    public void setPrev(SelectColumnsHolder holder) {
        this.prev = holder;
    }

    public List<ColumnAlias> getTableSourceColumnAliases() {
        return this.tableSourceColumnAliases;
    }

    public String getFullName() {
        return this.fullName;
    }

    public ParserRuleContext getContext() {
        return this.context;
    }

    public void setContext(ParserRuleContext context) {
        this.context = context;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public SelectColumnsHolder getParent() {
        return this.parent;
    }

    public SelectColumnsHolder getPrev() {
        return this.prev;
    }

    public JoinExpression getJoin() {
        return this.join;
    }

    public String toString() {
        return String.valueOf(this.cte ? "CTE: " + this.getName() : "") + "{" + this.source + "}, " + super.toString();
    }

    public void setCTE(boolean b) {
        this.cte = b;
    }

    public boolean isCTE() {
        return this.cte;
    }

    public SearchConditionNot getHaving() {
        return this.having;
    }

    public void setHaving(SearchConditionNot having) {
        this.having = having;
    }

    public SearchConditionNot getWhere() {
        return this.where;
    }

    public void setWhere(SearchConditionNot where) {
        this.where = where;
    }

    public List<Expression> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<Expression> groupBy) {
        this.groupBy = groupBy;
    }

    public OrderByClauseExpression getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderByClauseExpression orderBy) {
        this.orderBy = orderBy;
    }

    public void addUnion(SelectColumnsHolder holder) {
        this.unions.add(holder);
        if (holder.getOrderBy() != null) {
            this.orderBy = holder.getOrderBy();
            holder.orderBy = null;
        }
    }

    public List<SelectColumnsHolder> getUnions() {
        return this.unions;
    }
}

