/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.google.inject.Singleton;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import com.sigge.dbrunner.sqlserver.SQLServerDatabaseConfig;
import com.sigge.filerunner.completion.domain.ServerConfig;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.Encrypter;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.IDatabaseContextOperator;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.SQLServerContext;
import com.sigge.filerunner.sql.sqlserver.SQLServerDatabaseContext;

@Singleton
public class SQLServerDatabaseCreator
implements IDatabaseContextOperator {
    private static final String APPLICATION_NAME = "FileRunner";
    private static final String CONFIG_NAME = "db/sqlserver.json";
    private ServerConfig config;

    @Override
    public void initiate() {
        this.config = new ServerConfig(CONFIG_NAME);
    }

    @Override
    public Database create(DatabaseServerConfig db) {
        SQLServerDatabaseConfig config;
        if (!this.isValid(db)) {
            return null;
        }
        if (StringUtils.isNotEmpty(db.getUrl())) {
            config = new SQLServerDatabaseConfig(db.getUrl(), db.getServerLabel());
        } else {
            String password = db.getPassword();
            if (!db.getUseAD().booleanValue() && ConfigHandler.getConfig().isEncryptedData()) {
                try {
                    password = Encrypter.decrypt(password, DatabaseManager.getKeypass());
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't decode key", e);
                }
            }
            config = new SQLServerDatabaseConfig(db.getServer(), db.getUser(), password, db.getUseAD(), db.getServerLabel());
        }
        config.setApplicationName(APPLICATION_NAME);
        return new SQLServerDatabase(config);
    }

    @Override
    public boolean isValid(DatabaseServerConfig db) {
        if (!StringUtils.isEmpty(db.getUrl())) {
            return true;
        }
        if (!StringUtils.isEmpty(db.getServer())) {
            return StringUtils.isNoneEmpty(db.getUser()) || db.getUseAD() != false;
        }
        return false;
    }

    @Override
    public IServerContext createContext(Database database) {
        return new SQLServerContext(database, a -> new SQLServerDatabaseContext((ServerDatabase)a, this.config));
    }
}

