/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.completion.domain.EntityName;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.sql.AServerContext;
import com.sigge.filerunner.sql.CancellableCallback;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.SQLServerName;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class SQLServerContext
extends AServerContext {
    private final List<String> databases = new ArrayList<String>();

    public SQLServerContext(Database database, Function<ServerDatabase, DatabaseContext> contextCreator) {
        super(database, contextCreator);
        new Thread(this::initLazyContexts).start();
    }

    private void initLazyContexts() {
        try {
            this.databases.addAll(this.database.getDatabases());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public Optional<DatabaseContext> getContextForName(String name, DatabaseContext context) {
        return null;
    }

    @Override
    public List<SQLObject> getByNamePattern(String name, DatabaseContext defaultContext, SQLObjectType ... objectTypes) {
        return this.getByNameOrPattern(name, defaultContext, true, Optional.empty(), objectTypes);
    }

    @Override
    public List<SQLObject> getByName(String name, DatabaseContext defaultContext, SQLObjectType ... objectTypes) {
        return this.getByName(name, defaultContext, Optional.empty(), objectTypes);
    }

    @Override
    public List<SQLObject> getByName(String name, DatabaseContext defaultContext, Optional<CancellableCallback> contextReadyCallback, SQLObjectType ... objectTypes) {
        return this.getByNameOrPattern(name, defaultContext, false, contextReadyCallback, objectTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLObject> getByNameOrPattern(String name, DatabaseContext defaultContext, boolean fuzzy, Optional<CancellableCallback> contextReadyCallback, SQLObjectType ... objectTypes) {
        SQLServerName sqlName = new SQLServerName(name);
        DatabaseContext contextToUse = defaultContext;
        if (!sqlName.getDatabase().equals("")) {
            boolean contextfound = false;
            for (ServerDatabase sd : this.contexts.keySet()) {
                if (!sd.getDatabase().equals(sqlName.getDatabase())) continue;
                contextToUse = (DatabaseContext)this.contexts.get(sd);
                contextfound = true;
                break;
            }
            for (ServerDatabase sd : this.contexts.keySet()) {
                if (!sd.getDatabase().equalsIgnoreCase(sqlName.getDatabase())) continue;
                contextToUse = (DatabaseContext)this.contexts.get(sd);
                contextfound = true;
                break;
            }
            for (String db : this.databases) {
                if (!db.equalsIgnoreCase(sqlName.getDatabase())) continue;
                Map map = this.contexts;
                synchronized (map) {
                    contextToUse = (DatabaseContext)this.contexts.computeIfAbsent(new ServerDatabase(this.database, db), this.contextCreator);
                    contextfound = true;
                }
            }
            if (!contextfound) {
                return new ArrayList<SQLObject>();
            }
        }
        if (contextToUse == null || !contextToUse.isLoaded(contextReadyCallback.orElse(null))) {
            return new ArrayList<SQLObject>();
        }
        return contextToUse.getObjects(sqlName, fuzzy, objectTypes);
    }

    @Override
    public Optional<EntityName> parseEntity(String entityName) {
        return Optional.of(new SQLServerName(entityName));
    }
}

