/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.sql.CancellableCallback;
import com.sigge.filerunner.sql.edit.ISQLColumnTableListener;
import com.sigge.filerunner.sql.edit.ParseError;
import com.sigge.filerunner.sql.edit.ParseSource;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.transform.dml.SelectColumn;
import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.expression.ColumnNameExpression;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.FullExpression;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.select.source.Source;
import com.sigge.filerunner.sql.transform.select.source.SourceType;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTableListener
implements ISQLColumnTableListener {
    List<ParseError> parseResult;
    private final CancellableCallback callback;
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLTableListener.class);

    public SQLTableListener(List<ParseError> parseResult, CancellableCallback callback) {
        if (parseResult != null) {
            int i = parseResult.size() - 1;
            while (i >= 0) {
                block4: {
                    try {
                        if (parseResult.get(i).getParseSource() != ParseSource.CONTEXT) break block4;
                        parseResult.remove(i);
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
                --i;
            }
        }
        this.parseResult = parseResult;
        this.callback = callback;
    }

    @Override
    public void acceptUnresolvedTableSource(Source xx) {
        Object q = xx.getTreeAsContext();
        SourceType type = xx.getSourceType();
        String tableType = "table";
        if (type != null) {
            tableType = type.getType();
        }
        if (xx.getSource() != null && xx.getSource() instanceof BaseExpression) {
            q = ((BaseExpression)xx.getSource()).getTree() instanceof ParserRuleContext ? ((BaseExpression)xx.getSource()).getTreeAsContext() : ((BaseExpression)xx.getSource()).getTree();
        }
        this.createErrorFromTree((ParseTree)q, "Unresolved " + tableType + " " + ClauseUtility.getExpressionTree((ParseTree)q));
    }

    void createErrorFromTree(ParseTree pt, String error) {
        this.createErrorFromTree(pt, error, false);
    }

    void createErrorFromTree(ParseTree pt, String error, boolean warning) {
        Token end;
        Token start;
        if (pt == null) {
            return;
        }
        if (pt.getPayload() instanceof Token) {
            start = (Token)pt.getPayload();
            end = (Token)pt.getPayload();
        } else if (pt.getPayload() instanceof ParserRuleContext) {
            start = ((ParserRuleContext)pt.getPayload()).getStart();
            end = ((ParserRuleContext)pt.getPayload()).getStop();
        } else {
            return;
        }
        if (start == null) {
            start = end;
        } else if (end == null) {
            end = start;
        }
        if (end == null) {
            return;
        }
        ParseError e2 = new ParseError(start.getLine(), start.getStartIndex(), end.getStopIndex(), error, warning, ParseSource.CONTEXT);
        this.parseResult.add(e2);
    }

    @Override
    public void acceptUnresolvedTableAlias(SelectColumn column, String tableAlias) {
        Expression column2 = column.getColumn();
        if (column2 instanceof BaseExpression) {
            BaseExpression base = (BaseExpression)column2;
            this.createErrorFromTree(base.getTree(), "Unresolved table alias: " + tableAlias);
        } else if (column2 instanceof FullExpression && ((FullExpression)column2).getFullExpression() instanceof ColumnNameExpression) {
            ParserRuleContext q = ((ColumnNameExpression)((FullExpression)column2).getFullExpression()).getTreeAsContext();
            this.acceptUnresolvedTableAlias(q, tableAlias);
        } else if (column2 instanceof TerminalNode) {
            this.createErrorFromToken((TerminalNode)column2);
        } else if (column.getTableNameOrAlias() != null) {
            SQLName alias = column.getTableNameOrAlias();
            this.createErrorFromTree(alias.getTokenSource(), "Unresolved alias: " + alias.fullName());
        }
    }

    @Override
    public void acceptMessage(ParserRuleContext object, String errorMessage, boolean warning) {
        this.createErrorFromTree((ParseTree)object, errorMessage, warning);
    }

    public void createErrorFromToken(TerminalNode term) {
        Token t = (Token)term.getPayload();
        if (t != null) {
            ParseError e2 = new ParseError(t.getLine(), t.getStartIndex(), t.getStopIndex(), "Unresolved alias: " + t.getText(), false, ParseSource.CONTEXT);
            this.parseResult.add(e2);
        }
    }

    @Override
    public void acceptUnresolvedTableAlias(ParserRuleContext context, String alias) {
        this.createErrorFromTree((ParseTree)context, "Unresolved alias: " + alias);
    }

    @Override
    public void acceptUnresolvedColumn(SelectColumn column) {
        Expression column2 = column.getColumn();
        if (column2 instanceof BaseExpression) {
            BaseExpression base = (BaseExpression)column2;
            this.createErrorFromTree(base.getTree(), "Unresolved column: " + base.getValue());
        } else if (column2 instanceof FullExpression && ((FullExpression)column2).getFullExpression() instanceof ColumnNameExpression) {
            ParserRuleContext q = ((ColumnNameExpression)((FullExpression)column2).getFullExpression()).getTreeAsContext();
            this.acceptUnresolvedColumn(q);
        }
    }

    @Override
    public void acceptErrorMessage(ParserRuleContext object, String errorMessage) {
        this.createErrorFromTree((ParseTree)object, errorMessage);
    }

    @Override
    public void acceptMessage(Token t, String errorMessage, boolean warning) {
        ParseError e2 = new ParseError(t.getLine(), t.getStartIndex(), t.getStopIndex(), errorMessage, warning, ParseSource.CONTEXT);
        this.parseResult.add(e2);
    }

    @Override
    public void acceptUnresolvedColumn(ParserRuleContext column) {
        this.createErrorFromTree((ParseTree)column, "Unresolved column: " + column.getText());
    }

    @Override
    public void acceptUnresolvedVariable(ParserRuleContext variable) {
        this.createErrorFromTree((ParseTree)variable, "Unresolved variable");
    }

    @Override
    public void acceptUnresolvedObject(ParserRuleContext object, String objectName) {
        this.createErrorFromTree((ParseTree)object, "Unresolved " + objectName);
    }

    @Override
    public Optional<CancellableCallback> getCallbackForContext() {
        return Optional.ofNullable(this.callback);
    }
}

