/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.sql.sqlserver.SelectColumnsHolder;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ParsingContext {
    private final List<SQLObject> declareTables = new ArrayList<SQLObject>();
    private final List<DeclareBlock> declaredVariables;
    private final Set<SelectColumnsHolder> holders = new HashSet<SelectColumnsHolder>();
    private final List<SQLObject> declareObjects = new ArrayList<SQLObject>();

    public ParsingContext(List<SQLObject> declareObjects, List<DeclareBlock> declaredVariables) {
        this.declaredVariables = declaredVariables;
        for (SQLObject so : declareObjects) {
            if (so.ofType(SQLObjectType.TABLE)) {
                this.declareTables.add(so);
                continue;
            }
            this.declareObjects.add(so);
        }
    }

    public ParsingContext(List<SQLObject> declareTables) {
        this(declareTables, Collections.EMPTY_LIST);
    }

    public List<SQLObject> getDeclareTables() {
        return this.declareTables;
    }

    public List<DeclareBlock> getDeclaredVariables() {
        return this.declaredVariables;
    }

    public void addSelectColumnHolder(SelectColumnsHolder holder) {
        this.holders.add(holder);
    }

    public void removeSelectColumnHolder(SelectColumnsHolder holder) {
        this.holders.remove(holder);
    }

    public Set<SelectColumnsHolder> getHolders() {
        return this.holders;
    }

    public List<SQLObject> getDeclareObjects() {
        return this.declareObjects;
    }
}

