/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.edit.ISQLColumnTableListener;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class ColumnListCheck {
    private final Map<String, List<SQLName>> map = new ConcurrentHashMap<String, List<SQLName>>();

    public ColumnListCheck(List<SQLName> names) {
        int i = 0;
        while (i < names.size()) {
            SQLName sn = names.get(i);
            if (StringUtils.isNotEmpty(sn.getName())) {
                this.map.computeIfAbsent(sn.getName().toLowerCase(), f -> new ArrayList()).add(sn);
            }
            ++i;
        }
    }

    public ColumnListCheck(Stream<SQLName> names) {
        names.filter(n -> n != null && StringUtils.isNotEmpty(n.getName())).forEachOrdered(n -> this.map.computeIfAbsent(n.getName().toLowerCase(), f -> new ArrayList()).add(n));
    }

    public void validate(ISQLColumnTableListener listener) {
        for (String key : this.map.keySet()) {
            List<SQLName> names = this.map.get(key);
            int i = 0;
            while (names.size() > 1 && i < names.size()) {
                SQLName n = names.get(i);
                if (n.getStartToken().isPresent()) {
                    listener.acceptMessage(n.getStartToken().get(), "Duplicate column: " + n.getName(), i == 0);
                }
                ++i;
            }
        }
    }
}

