/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.completion.domain.EntityName;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.IDatabaseContextOperator;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.changedb.ChangeDatabaseListener;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SQLManager {
    static final SQLOptions SQL_OPTIONS = new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).build();
    private ServerDatabase current = null;
    private List<ServerDatabase> currents = Collections.emptyList();
    private final Map<Database, IServerContext> serverContextMap = new HashMap<Database, IServerContext>();
    public static final String DATABASE_TYPE = "DATABASE";
    public static final String SCHEMA_TYPE = "SCHEMA";
    public static final String TABLE_TYPE = "TABLE";
    public static final String VIEW_TYPE = "VIEW";
    private final Logger LOGGER = LoggerFactory.getLogger(SQLManager.class);
    private final List<ChangeDatabaseListener> listeners = new ArrayList<ChangeDatabaseListener>();
    private final Map<String, IDatabaseContextOperator> serverContextCreationMap;

    @Inject
    public SQLManager(Map<String, IDatabaseContextOperator> serverContextCreationMap) {
        this.serverContextCreationMap = serverContextCreationMap;
        this.LOGGER.debug("Created SQL Manager");
    }

    public void reloadDbs() {
        for (IServerContext context : this.serverContextMap.values()) {
            try {
                context.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.serverContextMap.clear();
        this.current = null;
        this.currents = Collections.emptyList();
    }

    public void addChangeDatabaseListener(ChangeDatabaseListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeDatabaseListener(ChangeDatabaseListener listener) {
        this.listeners.remove(listener);
    }

    public Optional<EntityName> parseEntity(String entityName) {
        IServerContext cx = this.getServerContext();
        if (cx == null) {
            return Optional.empty();
        }
        return cx.parseEntity(entityName);
    }

    public List<SQLObject> getByName(String name, SQLObjectType ... objectTypes) {
        IServerContext cx = this.getServerContext();
        if (cx == null) {
            return Collections.EMPTY_LIST;
        }
        return cx.getByName(name, this.getCurrentContext(), objectTypes);
    }

    public List<SQLObject> getByNamePattern(String name, SQLObjectType ... objectTypes) {
        IServerContext cx = this.getServerContext();
        if (cx == null) {
            return Collections.EMPTY_LIST;
        }
        return cx.getByNamePattern(name, this.getCurrentContext(), objectTypes);
    }

    public IServerContext getServerContext() {
        if (this.current != null) {
            return this.serverContextMap.get(this.current.getDb());
        }
        return null;
    }

    public IServerContext getContextFromDatabase(ServerDatabase db) {
        if (db == null) {
            return null;
        }
        IServerContext context = this.serverContextMap.get(db.getDb());
        if (context == null) {
            this.LOGGER.error("Couldn't find context for: " + db);
        }
        return context;
    }

    public void getObjectDefinition(SQLObject object, Consumer<String> definitionConsumer, Consumer<Exception> onError) {
        DatabaseContext cx;
        DatabaseContext databaseContext = cx = object.getContext() != null ? object.getContext() : this.getCurrentContext();
        if (cx == null) {
            onError.accept(new RuntimeException("Database isn't initialized yet"));
            return;
        }
        if (cx.isRunning()) {
            onError.accept(new RuntimeException("Database is being initialized right now"));
            return;
        }
        new BackgroundRunner(() -> cx.getObjectDefinition(object, definitionConsumer, onError)).execute();
    }

    public Optional<String> getObjectDefinition(SQLObject object, Consumer<Exception> onError) {
        DatabaseContext cx;
        DatabaseContext databaseContext = cx = object.getContext() != null ? object.getContext() : this.getCurrentContext();
        if (cx == null) {
            onError.accept(new RuntimeException("Database isn't initialized yet"));
            return Optional.empty();
        }
        if (cx.isRunning()) {
            onError.accept(new RuntimeException("Database is being initialized right now"));
            return Optional.empty();
        }
        return cx.getObjectDefinition(object, onError);
    }

    public DatabaseContext getCurrentContext() {
        IServerContext iServerContext;
        IServerContext iServerContext2 = iServerContext = this.current != null ? this.serverContextMap.get(this.current.getDb()) : null;
        if (iServerContext == null) {
            return null;
        }
        return iServerContext.getContextForDatabase(this.current);
    }

    public String getSelectRowsSQL(SQLObject so, int rowNumber) {
        return so.getContext().getSelectQuery(so, rowNumber);
    }

    public String getCountRowsSQL(SQLObject so) {
        return "SELECT  COUNT(*) AS row_count FROM    " + so.getContext().getQuotedName(so);
    }

    public Stream<SQLObject> getByFilter(Predicate<SQLObject> f, String filter) {
        DatabaseContext cx = this.getCurrentContext();
        if (cx == null) {
            return Stream.empty();
        }
        int length = filter.length();
        String fuzzyFilter = FilterHelper.getRegexFromString2(filter);
        return Stream.concat(cx.getObjects().parallelStream(), cx.getDatabases().parallelStream()).filter(p -> f.test((SQLObject)p) && p.getName().length() >= length && (filter.matches("\\d+") && p.getName().startsWith(filter) || !filter.matches("\\d+") && p.getName().matches(fuzzyFilter)));
    }

    public Stream<SQLObject> getByFilter(Predicate<SQLObject> filter) {
        DatabaseContext cx = this.getCurrentContext();
        if (cx == null) {
            return Stream.empty();
        }
        return cx.getObjects().parallelStream().filter(p -> filter.test((SQLObject)p));
    }

    public boolean schemaExist(String schema) {
        if (schema != null && schema.length() > 0) {
            DatabaseContext cx = this.getCurrentContext();
            if (cx == null) {
                return false;
            }
            return cx.getSchemas().stream().anyMatch(s -> s.getName().equalsIgnoreCase(schema));
        }
        return false;
    }

    public ServerDatabase getCurrent() {
        return this.current;
    }

    public List<? extends ServerDatabase> getCurrents() {
        return this.currents;
    }

    public void setCurrent(ServerDatabase newCurrent) {
        if (Objects.equal((Object)newCurrent, (Object)this.current)) {
            return;
        }
        if (newCurrent != null) {
            this.currents = Arrays.asList(newCurrent);
        }
        this.newCurrent(newCurrent);
        this.propagateChanges(Arrays.asList(newCurrent));
    }

    public void setCurrent(List<ServerDatabase> newDbs) {
        if (newDbs.size() == 0) {
            this.newCurrent(null);
        } else {
            if (Objects.equal(this.currents, newDbs) && Objects.equal((Object)newDbs.get(0), (Object)this.current)) {
                return;
            }
            this.currents = newDbs;
            if (this.current == null || newDbs.indexOf(this.current) < 0) {
                this.newCurrent(newDbs.get(0));
            }
        }
        this.propagateChanges(newDbs);
    }

    private IServerContext createServerContext(Database d) {
        IDatabaseContextOperator dbo = this.serverContextCreationMap.get(d.getDatabaseProvider());
        if (dbo != null) {
            return dbo.createContext(d);
        }
        this.LOGGER.error("Unsupported database provider");
        return null;
    }

    private void newCurrent(ServerDatabase newCurrent) {
        this.current = newCurrent;
        this.newDatabase(this.current);
    }

    private void propagateChanges(List<ServerDatabase> newCurrent) {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            this.listeners.get(i).newDatabase(newCurrent, this.current);
            --i;
        }
    }

    public String getMaybeSchema(String text) {
        String schema = "";
        if (text != null) {
            if (text.endsWith(".")) {
                String[] parts = text.split("\\.");
                schema = parts.length > 0 ? parts[parts.length - 1].trim() : "";
            } else if (text.contains(".")) {
                String[] parts = text.split("\\.");
                int i = parts.length - 1;
                while (i >= 0) {
                    if (this.schemaExist(parts[i])) {
                        return parts[i];
                    }
                    --i;
                }
            }
        }
        return schema;
    }

    private void newDatabase(ServerDatabase sb) {
        if (sb == null) {
            return;
        }
        try {
            IServerContext cx = this.serverContextMap.computeIfAbsent(sb.getDb(), this::createServerContext);
            if (cx != null) {
                cx.changeDatabase(sb);
            }
        }
        catch (Exception e1) {
            System.out.println(e1);
            return;
        }
    }

    public boolean needsSchema(SQLObject l) {
        return this.getCurrentContext().needsSchema(l);
    }

    public void addUsage(SQLObject so, Optional<SQLSubObject> sub) {
        DatabaseContext ctx = so.getContext();
        if (ctx == null) {
            Integer serverId = so.getContextServerId();
            String database = so.getContextDatabase();
            if (serverId == null || database == null) {
                return;
            }
            for (Database db : this.serverContextMap.keySet()) {
                DatabaseFromConfig conf = (DatabaseFromConfig)db;
                if (conf.getConfig().getId() != serverId.intValue()) continue;
                IServerContext sec = this.serverContextMap.get(db);
                ctx = sec.getContextForDatabase(new ServerDatabase(conf, database));
                break;
            }
        }
        if (ctx != null) {
            ctx.addObjectUsage(so, sub);
        }
    }

    public static Tuple<Integer, String> getDatabaseIdFromContext(DatabaseContext context) {
        ServerDatabase x = context.getDatabase();
        if (x == null) {
            return null;
        }
        DatabaseFromConfig config = (DatabaseFromConfig)x.getDb();
        int serverId = config.getConfig().getId();
        String database = x.getDatabase();
        return Tuple.of((Object)serverId, (Object)database);
    }

    public static Tuple<Integer, String> getDatabaseIdFromContext(ServerDatabase context) {
        DatabaseFromConfig config = (DatabaseFromConfig)context.getDb();
        int serverId = config.getConfig().getId();
        String database = context.getDatabase();
        return Tuple.of((Object)serverId, (Object)database);
    }
}

