/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.FileRunnerProgressReporter;
import com.sigge.filerunner.sql.IOutput;
import com.sigge.filerunner.sql.RunContext;
import com.sigge.filerunner.sql.Server;
import com.sigge.fileutils.EncodingDetector;
import com.sigge.fileutils.SkipBOMReader;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunFilesInDBs {
    private static final EncodingDetector ed = new EncodingDetector();
    private static final SQLOptions DEFAULT_OPTIONS = new SQLOptions.Builder().parseOnly(false).build();
    private static final Logger LOGGER = LoggerFactory.getLogger(RunFilesInDBs.class);

    public static void run(List<Server> servers, String script, List<File> files, List<FileRunnerProgressReporter> progress, IOutput output) {
        RunFilesInDBs.run(servers, script, files, progress, DEFAULT_OPTIONS, output);
    }

    public static void run(List<Server> servers, String script, List<File> files, List<FileRunnerProgressReporter> progress, SQLOptions options, IOutput output) {
        if (progress == null) {
            throw new IllegalArgumentException("progress list cannot be null");
        }
        progress.stream().forEach(l -> l.reportStarted(options));
        new BackgroundRunner(() -> RunFilesInDBs.lambda$1(progress, servers, files, script, options, output)).execute();
    }

    private static void runInternal(List<Server> servers, File file, String script, List<FileRunnerProgressReporter> progress, SQLOptions options, IOutput output) {
        block5: for (Server server : servers) {
            if (options.isCancelled()) break;
            progress.forEach(l -> {
                l.setRunContext(new RunContext(server, null, null, null, options, output));
                l.reportServerStarted();
            });
            for (String db : server.getDatabases()) {
                if (options.isCancelled()) break block5;
                progress.forEach(l -> l.setRunContext(new RunContext(server, db, file, script, options, output)));
                try {
                    Reader r = null;
                    r = file != null ? new BufferedReader((Reader)new SkipBOMReader((InputStream)new FileInputStream(new File(file.getPath())), ed.detectFileEncoding(new File(file.getPath())))) : new StringReader(script);
                    if (options.isCancelled()) break block5;
                    IScriptRunner runner = server.getDatabase().createRunner(db, options);
                    try {
                        runner.runScript(r, progress.stream().map(l -> l).collect(Collectors.toList()), options);
                    }
                    finally {
                        runner.closeConnection();
                    }
                }
                catch (Exception ex) {
                    progress.stream().forEach(l -> l.reportScriptFailure("Script run", null, ex, false));
                    throw new RuntimeException("Exception " + ex + "occured while processing db:" + db + ", file:" + (file != null ? file.getName() : "-"), ex);
                }
            }
            progress.forEach(l -> {
                l.setRunContext(new RunContext(server, null, null, null, options, output));
                l.reportServerFinished();
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$1(List var0, List var1_1, List var2_2, String var3_3, SQLOptions var4_4, IOutput var5_5) throws Throwable {
        block11: {
            block10: {
                try {
                    try {
                        if (var2_2 != null) {
                            for (File file : var2_2) {
                                RunFilesInDBs.runInternal(var1_1, file, var3_3, var0, var4_4, var5_5);
                            }
                        } else {
                            RunFilesInDBs.runInternal(var1_1, null, var3_3, var0, var4_4, var5_5);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        RunFilesInDBs.LOGGER.error("Error while running queries", (Throwable)e);
                        var0.stream().forEachOrdered((Consumer<FileRunnerProgressReporter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$2(com.sigge.filerunner.core.FileRunnerProgressReporter ), (Lcom/sigge/filerunner/core/FileRunnerProgressReporter;)V)());
                        ** for (server : var1_1)
                    }
                }
                catch (Throwable var8_15) {
                    var0.stream().forEachOrdered((Consumer<FileRunnerProgressReporter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$2(com.sigge.filerunner.core.FileRunnerProgressReporter ), (Lcom/sigge/filerunner/core/FileRunnerProgressReporter;)V)());
                    ** for (server : var1_1)
                }
lbl-1000:
                // 1 sources

                {
                    server.getDatabase().closeAllSessions();
                    continue;
lbl16:
                    // 1 sources

                    break block11;
                }
lbl-1000:
                // 1 sources

                {
                    server.getDatabase().closeAllSessions();
                    continue;
                }
lbl22:
                // 1 sources

                throw var8_15;
            }
            var0.stream().forEachOrdered((Consumer<FileRunnerProgressReporter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$2(com.sigge.filerunner.core.FileRunnerProgressReporter ), (Lcom/sigge/filerunner/core/FileRunnerProgressReporter;)V)());
            for (Server server : var1_1) {
                server.getDatabase().closeAllSessions();
            }
        }
    }

    private static /* synthetic */ void lambda$2(FileRunnerProgressReporter l) {
        l.reportFinished();
    }
}

