/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.sql.IOutput;
import com.sigge.filerunner.sql.Server;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Objects;

public class RunContext {
    private final Server server;
    private final String database;
    private final File file;
    private final String script;
    private final SQLOptions options;
    private LocalDateTime serverStarted;
    private LocalDateTime serverFinished;
    private final IOutput outputFormat;

    public RunContext(Server server, String database, File file, String script, SQLOptions options, IOutput outputFormat) {
        this.server = server;
        this.database = database;
        this.file = file;
        this.script = script;
        this.options = options;
        this.outputFormat = outputFormat;
    }

    public Server getServer() {
        return this.server;
    }

    public String getDatabase() {
        return this.database;
    }

    public File getFile() {
        return this.file;
    }

    public String getScript() {
        return this.script;
    }

    public SQLOptions getOptions() {
        return this.options;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunContext)) {
            return false;
        }
        RunContext other = (RunContext)obj;
        return Objects.equals(this.database, other.database) && Objects.equals(this.file, other.file) && Objects.equals(this.script, other.script) && Objects.equals(this.server, other.server);
    }

    public LocalDateTime getServerStarted() {
        return this.serverStarted;
    }

    public void setServerStarted(LocalDateTime serverStarted) {
        this.serverStarted = serverStarted;
    }

    public LocalDateTime getServerFinished() {
        return this.serverFinished;
    }

    public void setServerFinished(LocalDateTime serverFinished) {
        this.serverFinished = serverFinished;
    }

    public IOutput getOutputFormat() {
        return this.outputFormat;
    }
}

