/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class DatabaseFromConfig
implements Database {
    private final Database db;
    private final RunnerServerConfig config;

    DatabaseFromConfig(Database db, RunnerServerConfig config) {
        this.db = db;
        this.config = config;
    }

    @Override
    public String getDatabaseProvider() {
        return this.db.getDatabaseProvider();
    }

    @Override
    public String getServer() {
        return this.db.getServer();
    }

    @Override
    public String getUser() {
        return this.db.getUser();
    }

    @Override
    public String getPassword() {
        return this.db.getPassword();
    }

    @Override
    public String getUrl() {
        return this.db.getUrl();
    }

    @Override
    public boolean isUseAD() {
        return this.db.isUseAD();
    }

    @Override
    public String getServerLabel() {
        return this.db.getServerLabel();
    }

    @Override
    public String getUniqueProviderName() {
        return this.db.getUniqueProviderName();
    }

    @Override
    public Connection createConnection(String database, Object options) throws SQLException {
        return this.db.createConnection(database, options);
    }

    @Override
    public void executeScript(Reader scriptText, String databaseName, SQLOptions options) throws SQLException, Exception {
        this.db.executeScript(scriptText, databaseName, options);
    }

    @Override
    public void executeScript(Reader scriptText, String databaseName, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, Exception {
        this.db.executeScript(scriptText, databaseName, reporter, options);
    }

    @Override
    public IScriptRunner createRunner(String databaseName, Object options) throws SQLException {
        return this.db.createRunner(databaseName, options);
    }

    @Override
    public boolean checkConnection() {
        return this.db.checkConnection();
    }

    @Override
    public List<String> getDatabases() throws SQLException {
        return this.db.getDatabases();
    }

    @Override
    public void closeAllSessions() {
        this.db.closeAllSessions();
    }

    @Override
    public void executeScript(Reader scriptText, IScriptRunner scriptRunner, String databaseName, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, Exception {
        this.db.executeScript(scriptText, scriptRunner, databaseName, reporter, options);
    }

    public RunnerServerConfig getConfig() {
        return this.config;
    }

    @Override
    public IDatabaseOperator getDatabaseOperator() {
        return this.db.getDatabaseOperator();
    }

    public Database getDb() {
        return this.db;
    }

    public String toString() {
        String user = this.db.getUser();
        String server = this.db.getServer();
        return StringUtils.isBlank(this.db.getUrl(), user != null || server != null ? (user != null ? String.valueOf(user) + "@" : server) : super.toString());
    }

    @Override
    public String getConnectionUrl() {
        return this.db.getConnectionUrl();
    }
}

