/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.recent;

import java.time.LocalDate;

public class RecentFilter {
    private Integer year;
    private Integer month;
    private Integer day;
    private LocalDate date;
    private LocalDate from;
    private LocalDate to;
    private String freetext;
    private boolean empty = true;
    private boolean onlyLastFile;
    private int maxItems = 300;

    private RecentFilter() {
    }

    public static RecentFilter create() {
        return new RecentFilter();
    }

    public static RecentFilter lastXYears(int years) {
        RecentFilter filter = new RecentFilter();
        filter.year = -years;
        filter.empty = false;
        return filter;
    }

    public static RecentFilter byDate(LocalDate date) {
        RecentFilter filter = new RecentFilter();
        filter.date = date;
        filter.empty = false;
        return filter;
    }

    public static RecentFilter byDateRange(LocalDate from, LocalDate to) {
        RecentFilter filter = new RecentFilter();
        filter.from = from;
        filter.to = to;
        filter.empty = false;
        return filter;
    }

    public static RecentFilter byDateRange(LocalDate from) {
        RecentFilter filter = new RecentFilter();
        filter.from = from;
        filter.empty = false;
        return filter;
    }

    public static RecentFilter lastXMonths(int months) {
        RecentFilter filter = new RecentFilter();
        filter.month = -months;
        filter.empty = false;
        return filter;
    }

    public RecentFilter freetext(String freetext) {
        this.freetext = freetext;
        this.empty = false;
        return this;
    }

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public String getFreetext() {
        return this.freetext;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public RecentFilter setTo(LocalDate to) {
        this.to = to;
        return this;
    }

    public RecentFilter setOnlyLastFile(boolean onlyLastFile) {
        this.onlyLastFile = onlyLastFile;
        return this;
    }

    public boolean isOnlyLastFile() {
        return this.onlyLastFile;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public RecentFilter setMaxItems(int maxItems) {
        this.maxItems = maxItems;
        return this;
    }
}

