/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.raw;

import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.DataType;
import com.sigge.dbrunner.table.IBinder;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.filerunner.core.Encoding;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.imports.core.AImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.raw.RawImportSettings;
import com.sigge.filerunner.imports.raw.RawPanel;
import com.sigge.filerunner.imports.raw.RawSettingsModel;
import com.sigge.filerunner.imports.raw.RawStyle;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.DialogView;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.siggemannen.binding.APresenter;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.ICompletionProgress;
import com.siggemannen.view.IStatusProgress;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.RootPaneContainer;

public class RawImporter
extends AImporter<RawImportSettings> {
    public RawImporter(RootPaneContainer container) {
        super(container);
    }

    @Override
    protected boolean isSupportsMultipleFiles() {
        return true;
    }

    @Override
    protected ImportResult doImport(ServerDatabase currentDatabase, List<File> files, RawImportSettings settings, Tuple<ICompletionProgress, IStatusProgress> statusTuple) {
        IDatabaseOperator op = currentDatabase.getDb().getDatabaseOperator();
        ArrayList<Column> col = new ArrayList<Column>();
        RawStyle exportStyle = settings.getStyle();
        if (StringUtils.isNotEmpty(settings.getDataType())) {
            col.add(new Column(settings.getColumnName(), settings.getDataType()));
        } else if (exportStyle == RawStyle.BINARY_FILE) {
            col.add(new Column(settings.getColumnName(), ColumnType.VARBINARY));
        } else {
            col.add(new Column(settings.getColumnName(), new ColumnType(DataType.TEXT)));
        }
        try {
            ITableOperator tableOperator = op.getTableOperator();
            ITable table = tableOperator.openOrCreate(currentDatabase.getDatabase(), settings.getTableName(), "", col);
            ArrayList<ColumnMapping> mapping = new ArrayList<ColumnMapping>();
            mapping.add(new ColumnMapping((Column)col.get(0), 0));
            for (File f : files) {
                if (exportStyle == RawStyle.BINARY_FILE) {
                    Throwable throwable = null;
                    Object var14_16 = null;
                    try (final FileInputStream fis = new FileInputStream(f);){
                        tableOperator.insert(table, col, new IBinder(){
                            private int cnt = 0;

                            @Override
                            public boolean next() {
                                if (this.cnt < 1) {
                                    ++this.cnt;
                                    return true;
                                }
                                return false;
                            }

                            @Override
                            public void bind(PreparedStatement ps, int row, int column, int parameterIndex) throws SQLException {
                                ps.setBinaryStream(parameterIndex, fis);
                            }
                        });
                        continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                final String content = FileUtils.fileContent(f, settings.getEncoding() != Encoding.AUTO_DETECT ? settings.getEncoding().getEncoding() : null);
                tableOperator.insert(table, col, new IBinder(){
                    private int cnt = 0;

                    @Override
                    public boolean next() {
                        if (this.cnt < 1) {
                            ++this.cnt;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void bind(PreparedStatement ps, int row, int column, int parameterIndex) throws SQLException {
                        ps.setString(parameterIndex, content);
                    }
                });
            }
        }
        catch (Exception ex) {
            return new ImportResult(ex.getMessage());
        }
        return new ImportResult(files);
    }

    @Override
    protected RawImportSettings getSettings(ServerDatabase currentDatabase, List<File> files) {
        final RawPanel rp = new RawPanel();
        RawImportSettings ris = new RawImportSettings();
        RawSettingsModel model = new RawSettingsModel();
        APresenter<RawImportSettings, RawSettingsModel, RawPanel> presenter = new APresenter<RawImportSettings, RawSettingsModel, RawPanel>(model, rp){

            protected void initBindings() {
                this.bind(rp.tableName).to(((RawSettingsModel)this.model).tableName);
                this.bind(rp.columnName).to(((RawSettingsModel)this.model).columnName);
                this.bind(new JRadioButton[]{rp.binaryRadio, rp.textRadio}).to(((RawSettingsModel)this.model).style, (Object[])new RawStyle[]{RawStyle.BINARY_FILE, RawStyle.STRING_FILE});
                this.bind(rp.encodingCombo).to(Arrays.asList(Encoding.values()), ((RawSettingsModel)this.model).encoding);
                rp.encodingCombo.setRenderer(new LabelledCellRenderer(true));
                this.bind(rp.fieldType).to(((RawSettingsModel)this.model).dataType);
                ((RawSettingsModel)this.model).style.addListener(() -> rawPanel.encodingCombo.setEnabled(((RawSettingsModel)this.model).style.getValue() == RawStyle.STRING_FILE));
                ((RawSettingsModel)this.model).addModelChangeListener(() -> rawPanel.importButton.setEnabled(StringUtils.isNoneEmpty((String)((RawSettingsModel)this.model).tableName.getValue(), (String)((RawSettingsModel)this.model).columnName.getValue())));
            }
        };
        ris.setEncoding(Encoding.AUTO_DETECT);
        ris.setStyle(RawStyle.STRING_FILE);
        rp.dataTypeChk.addActionListener(new ActionListener(){
            String prev = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (rp.dataTypeChk.isSelected()) {
                    rp.fieldType.setText(this.prev);
                    rp.fieldType.setEnabled(true);
                } else {
                    this.prev = rp.fieldType.getText();
                    rp.fieldType.setText("");
                    rp.fieldType.setEnabled(false);
                }
            }
        });
        rp.browseButton.addActionListener(e -> {
            List<File> selected = this.getFilesImport(this.isSupportsMultipleFiles(), this.getFilters());
            if (selected != null && selected.size() > 0) {
                files.clear();
                files.addAll(selected);
                this.setFileInformation(files, rp);
            }
        });
        rp.fieldType.setEnabled(false);
        this.setFileInformation(files, rp);
        presenter.setObject((Object)ris);
        DialogView dv = new DialogView(this.container instanceof JFrame ? (JFrame)this.container : null, "Import settings", true);
        dv.setContent(rp, false);
        dv.addCancelAction(rp.cancelButton);
        dv.addOKAction(rp.importButton);
        rp.importButton.setEnabled(false);
        dv.centerOnCorrectScreen(this.container instanceof JFrame ? (JFrame)this.container : null);
        dv.setIconImage(IconUtils.getSmallIcon("file.png").getImage());
        dv.setVisible(true);
        if (dv.getReturnStatus() == 1) {
            return ris;
        }
        return null;
    }

    private void setFileInformation(List<File> files, RawPanel rp) {
        String fileString = files.stream().map(File::getAbsolutePath).reduce("", (a, b) -> String.valueOf(a) + (a.length() > 0 ? ";" : "") + b);
        rp.fileLabel.setText(files.size() == 1 ? "Import file as:" : "Import " + files.size() + " files as:");
        rp.filesPreview.setText(fileString);
        rp.filesPreview.setToolTipText(fileString);
    }

    @Override
    public String getIcon() {
        return "file.png";
    }

    @Override
    public String getLabel() {
        return "Raw files";
    }
}

