/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.geopackage;

import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.IBulk;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.imports.core.AImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.core.ImportTablePreview;
import com.sigge.filerunner.imports.geopackage.EsriPackageState;
import com.sigge.filerunner.imports.geopackage.GeoImportPanel;
import com.sigge.filerunner.imports.geopackage.GeoSettings;
import com.sigge.filerunner.imports.geopackage.GeoState;
import com.sigge.filerunner.imports.geopackage.geopackage.GeoPackageState;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.core.DialogView;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.ValueHolder;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.ICompletionProgress;
import com.siggemannen.view.IStatusProgress;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderRunnable;
import com.siggemannen.view.UIOptionRunnable;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.geopkg.FeatureEntry;
import org.jdesktop.swingx.JXErrorPane;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;

public class GeoPackageImporter
extends AImporter<GeoSettings> {
    public GeoPackageImporter(RootPaneContainer container) {
        super(container);
    }

    @Override
    public String getIcon() {
        return "map.png";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ImportResult doImport(ServerDatabase currentDatabase, List<File> f, final GeoSettings settings, Tuple<ICompletionProgress, IStatusProgress> statusTuple) {
        block32: {
            status = (IStatusProgress)statusTuple.second();
            status.status("Reading file");
            aix = new AtomicInteger(0);
            tableOperator = null;
            try {
                var8_8 = null;
                var9_11 = null;
                try {
                    block33: {
                        geo = this.getFromFile(f.get(0));
                        features = geo.getFeatureEntries();
                        fex = null;
                        for (FeatureEntry fe : features) {
                            if (fe.getIdentifier() == null || !fe.getIdentifier().equals(settings.getFeatureEntry().getIdentifier())) continue;
                            fex = fe;
                            break;
                        }
                        if (fex != null) break block32;
                        var21_18 = new ImportResult("File didn't have matching feature: " + settings.getFeatureEntry().getIdentifier());
                        if (geo == null) break block33;
                        geo.close();
                    }
                    if (tableOperator == null) return var21_18;
                }
                catch (Throwable var9_12) {
                    if (var8_8 == null) {
                        var8_8 = var9_12;
                        throw var8_8;
                    }
                    if (var8_8 == var9_12) throw var8_8;
                    var8_8.addSuppressed(var9_12);
                    throw var8_8;
                }
            }
            catch (Exception e) {
                status.status("Error after reading: " + aix.get() + " rows: " + e.getMessage(), Optional.of(e));
                var21_19 = new ImportResult("Error after reading: " + aix.get() + " rows: " + e.getMessage(), e);
                if (tableOperator == null) return var21_19;
                try {
                    tableOperator.close();
                    return var21_19;
                }
                catch (Exception var22_21) {
                    // empty catch block
                }
                return var21_19;
            }
            catch (Throwable var20_31) {
                throw var20_31;
            }
            try {
                tableOperator.close();
                return var21_18;
            }
            catch (Exception var22_20) {
                // empty catch block
            }
            return var21_18;
        }
        ** try [egrp 7[TRYBLOCK] [4 : 197->455)] { 
lbl54:
        // 1 sources

        cm = new ArrayList<ColumnMapping>();
        props = new ArrayList<E>();
        ordinals = new ArrayList<E>();
        t = this.prepareForImport(currentDatabase, settings.getTable(), settings, cm, Optional.of((Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(java.util.List com.sigge.filerunner.imports.geopackage.GeoSettings java.util.List java.lang.Integer ), (Ljava/lang/Integer;)V)(props, (GeoSettings)settings, ordinals)));
        tableOperator = t.getOperator();
        status.status("Ready for import of data");
        var17_26 = null;
        var18_28 = null;
        try {
            reader = geo.getReader(fex);
            try {
                status.status("Read in the file");
                tableOperator.insert(t, cm, new IBulk(){
                    SimpleFeature read;
                    int lastIndex = 0;
                    int maxIndex = 0;
                    LocalDateTime ld = DateUtils.getTimeAtUTC();

                    @Override
                    public boolean next() {
                        block4: {
                            try {
                                if (!status.isCancelled() && (this.lastIndex < this.maxIndex || reader.hasNext())) break block4;
                                return false;
                            }
                            catch (IOException e) {
                                status.cancel();
                                status.status("Error while reading", Optional.of(e));
                                return false;
                            }
                        }
                        if (this.lastIndex == this.maxIndex) {
                            this.read = (SimpleFeature)reader.next();
                        }
                        return this.read != null;
                    }

                    @Override
                    public Object[] getData() {
                        int counter = aix.incrementAndGet();
                        if (counter % 100 == 0 || DateUtils.isOlderThan(this.ld, 30000L)) {
                            status.status("Imported " + aix.get() + " rows");
                            this.ld = DateUtils.getTimeAtUTC();
                        }
                        Object[] ox = new Object[cm.size()];
                        int ord = 0;
                        while (ord < ordinals.size()) {
                            Property property;
                            int index2 = (Integer)ordinals.get(ord);
                            if (index2 <= props.size() && (property = this.read.getProperty((String)props.get(ord))) != null) {
                                Object value = property.getValue();
                                if (value instanceof Geometry) {
                                    Geometry geo = (Geometry)value;
                                    if (settings.isSplitGeoms()) {
                                        this.maxIndex = geo.getNumGeometries();
                                        geo = geo.getGeometryN(this.lastIndex++);
                                        value = geo;
                                        if (this.lastIndex >= this.maxIndex) {
                                            this.maxIndex = 0;
                                            this.lastIndex = 0;
                                        }
                                    }
                                    if (settings.isFixUpCoordinates()) {
                                        value = new GeometryFixer(geo).getResult();
                                    }
                                }
                                ox[ord] = value;
                            }
                            ++ord;
                        }
                        return ox;
                    }
                });
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable var18_29) {
            if (var17_26 == null) {
                var17_26 = var18_29;
                throw var17_26;
            }
            if (var17_26 == var18_29) throw var17_26;
            var17_26.addSuppressed(var18_29);
            throw var17_26;
        }
        if (status.isCancelled()) {
            status.status("Import cancelled, rows read: " + aix.get());
            return new ImportResult(f);
        }
        status.status("Finished, row inserted:" + aix.get());
        return new ImportResult(f);
lbl85:
        // 1 sources

        finally {
            if (geo != null) {
                geo.close();
            }
        }
    }

    @Override
    protected AImporter.ProgressType getProgressType() {
        return AImporter.ProgressType.UNDETERMINED;
    }

    @Override
    protected FileNameExtensionFilter[] getFilters() {
        return new FileNameExtensionFilter[]{new FileNameExtensionFilter("Geo files (*.gpkg; *.shp)", "gpkg", "shp")};
    }

    @Override
    protected GeoSettings getSettings(ServerDatabase currentDatabase, final List<File> files) {
        final GeoImportPanel gimp = new GeoImportPanel();
        DialogView ad = new DialogView(this.container instanceof JFrame ? (JFrame)this.container : null, "Import geo data", true);
        ad.addOKAction(gimp.importButton);
        ad.addCancelAction(gimp.cancelButton);
        ad.setContent(gimp, false);
        ad.centerOnCorrectScreen(this.container instanceof JFrame ? (JFrame)this.container : null);
        final GeoSettingModel gm = new GeoSettingModel();
        GeoSettings gs = new GeoSettings();
        APresenter<GeoSettings, GeoSettingModel, GeoImportPanel> presenter = new APresenter<GeoSettings, GeoSettingModel, GeoImportPanel>(gm, gimp){

            protected void initBindings() {
                this.bind(gimp.tableName).to(gm.tableName);
                ((GeoImportPanel)this.view).featureCombo.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        JLabel jal = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        if (value instanceof FeatureEntry) {
                            jal.setText(((FeatureEntry)value).getGeometryColumn());
                        }
                        return jal;
                    }
                });
                this.bind(gimp.fixUpCoordinatesCheckbox).to(gm.fixUpCoordinates);
                this.bind(gimp.splitGeoms).to(gm.splitGeoms);
                ((GeoImportPanel)this.view).browseButton.addActionListener(e -> {
                    List<File> selected = GeoPackageImporter.this.getFilesImport(GeoPackageImporter.this.isSupportsMultipleFiles(), GeoPackageImporter.this.getFilters());
                    if (selected != null && selected.size() > 0) {
                        files.clear();
                        files.addAll(selected);
                        GeoPackageImporter.this.recalculateGeoPackageThing(files, (APresenter<GeoSettings, GeoSettingModel, GeoImportPanel>)this);
                    }
                });
                ((GeoSettingModel)this.model).addModelChangeListener(() -> geoImportPanel.importButton.setEnabled(StringUtils.isNoneEmpty((String)((GeoSettingModel)this.model).tableName.getValue(), ((GeoSettingModel)this.model).featureEntry.getValue() != null ? ((FeatureEntry)((GeoSettingModel)this.model).featureEntry.getValue()).getGeometryColumn() : "")));
            }
        };
        presenter.setObject((Object)gs);
        this.setFileInformation(files, gimp.filesPreview);
        this.recalculateGeoPackageThing(files, presenter);
        ad.setVisible(true);
        return ad.getReturnStatus() == 1 ? gs : null;
    }

    private void recalculateGeoPackageThing(List<File> files, APresenter<GeoSettings, GeoSettingModel, GeoImportPanel> presenter) {
        if (files.size() == 0) {
            return;
        }
        File f = files.get(0);
        ValueHolder vh = new ValueHolder();
        UIOptionRunnable ui = (UIOptionRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)new UIOptionBuilderRunnable(() -> {
            IStatusProgress status = (IStatusProgress)vh.getValue();
            if (status.isCancelled()) {
                return;
            }
            Throwable throwable = null;
            Object var6_7 = null;
            try (GeoState g = this.getFromFile(f);){
                status.status("File opened");
                List<FeatureEntry> features = g.getFeatureEntries();
                presenter.bind((JComboBox)((GeoImportPanel)aPresenter.getView()).featureCombo).to(features, ((GeoSettingModel)aPresenter.getModel()).featureEntry);
                status.status(String.valueOf(features.size()) + " features read in");
                if (features.size() <= 0) {
                    return;
                }
                ((GeoImportPanel)aPresenter.getView()).featureCombo.setSelectedIndex(0);
                FeatureEntry fe = features.get(0);
                if (status.isCancelled()) {
                    return;
                }
                ImportTablePreview imp = new ImportTablePreview();
                Vector data = imp.getData();
                Vector headers = imp.getHeaders();
                HashMap<String, Integer> headerFields = new HashMap<String, Integer>();
                AtomicInteger ai = new AtomicInteger(0);
                Throwable throwable2 = null;
                Object var16_19 = null;
                try {
                    SimpleFeatureReader reader = g.getReader(fe);
                    int counter = 0;
                    {
                        catch (Throwable throwable3) {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable3;
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }).mainPanel(this.container)).title("Processing geopackage", "Processing file:" + f, "Cancel import")).exceptionCallback(ex -> JXErrorPane.showDialog((Throwable)ex))).dialogIcon(DialogView.DEFAULT_ICON)).progress((Consumer)vh)).build();
        UIBackgroundRunner.execute((UIOptionRunnable)ui);
    }

    private GeoState getFromFile(File f) throws Exception {
        if (f.getAbsolutePath().endsWith("gpkg")) {
            return new GeoPackageState(f);
        }
        if (f.getAbsolutePath().endsWith("shp")) {
            return new EsriPackageState(f);
        }
        throw new Exception("Cannot identify file, only pgkg or shpfiles accepted");
    }

    protected void setFileInformation(List<File> files, JTextField fileLabel) {
        String fileString = files.stream().map(File::getAbsolutePath).reduce("", (a, b) -> String.valueOf(a) + (a.length() > 0 ? ";" : "") + b);
        fileLabel.setText(fileString);
        fileLabel.setToolTipText(fileString);
    }

    private static /* synthetic */ void lambda$0(List list, GeoSettings geoSettings, List list2, Integer c) {
        list.add(geoSettings.getDbColumns().get(c).getName());
        list2.add(c + 1);
    }

    private static /* synthetic */ Integer lambda$2(AtomicInteger atomicInteger, String e) {
        return atomicInteger.getAndIncrement();
    }

    private static class GeoSettingModel
    extends AModel<GeoSettings> {
        IProperty<String> tableName = this.getProperty("table");
        IProperty<FeatureEntry> featureEntry = this.getProperty("featureEntry");
        IProperty<Boolean> fixUpCoordinates = this.getProperty("fixUpCoordinates");
        IProperty<Boolean> splitGeoms = this.getProperty("splitGeoms");

        private GeoSettingModel() {
        }
    }
}

