/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.excel;

import com.sigge.filerunner.imports.excel.SimpleCellType;
import java.util.HashMap;
import java.util.Map;

public class ExcelTypeDetector {
    private final Map<Integer, ExcelAggregator> columns = new HashMap<Integer, ExcelAggregator>();

    public void addCol(int col, SimpleCellType cellType, String value) {
        ExcelAggregator aggregator = this.columns.computeIfAbsent(col, e -> new ExcelAggregator());
        aggregator.add(cellType);
    }

    public SimpleCellType getCellType(int col) {
        ExcelAggregator ea = this.columns.get(col);
        if (ea == null) {
            return SimpleCellType.EMPTY;
        }
        return ea.finalCell;
    }

    private class ExcelAggregator {
        boolean finished = false;
        SimpleCellType finalCell = SimpleCellType.EMPTY;

        private ExcelAggregator() {
        }

        private boolean add(SimpleCellType c) {
            if (this.finished) {
                return this.finished;
            }
            this.finalCell = this.finalCell.merge(c);
            this.finished = this.finalCell == SimpleCellType.STRING;
            return this.finished;
        }
    }
}

