/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.csv;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.imports.core.ColumnEditor;
import com.sigge.filerunner.imports.core.ColumnSelected;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.HeaderRenderer;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.core.PreviewTableModel;
import com.sigge.filerunner.imports.core.PreviewTableRenderer;
import com.sigge.filerunner.imports.core.StringDataTypeDetector;
import com.sigge.filerunner.imports.csv.CSVImportSettings;
import com.sigge.filerunner.imports.csv.CSVPanel;
import com.sigge.filerunner.imports.csv.CSVPreferenceDialog;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.fileutils.EncodingDetector;
import com.sigge.fileutils.SkipBOMReader;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.SoftCopy;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableColumnExt;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CSVPreferenceHandler {
    private static final String IMPORT_CSV_QUOTE = "imports.csv.quote";
    private static final String IMPORT_CSV_SEPARATOR = "imports.csv.separator";
    private static final String IMPORT_CSV_FIRST_LINE_HEADER = "imports.csv.first_line_header";
    private static final String IMPORT_CSV_INCLUDE_ROW_NUMBER = "imports.csv.include_row_id";
    private static final String QUOTED_CHAR_SINGLE_QUOTE = "'";
    private static final String QUOTED_CHAR_DOUBLE_QUOTE = "\"";
    private static final String CHAR_SEPARATOR_SEMI_COMMA = ";";
    private static final String CHAR_SEPARATOR_COMMA = ",";
    private static final String CHAR_SEPARATOR_TAB = "\t";
    private static final String CHAR_SEPARATOR_PIPE = "|";
    private static final int MAX_ROWS = 200;
    private final FileImporterModel model;
    private final MainFrame view;
    private boolean result;
    private CSVImportSettings settings;
    private final EncodingDetector encodingDetector;
    private boolean ready;

    public CSVPreferenceHandler(FileImporterModel model, MainFrame view) {
        this.model = model;
        this.view = view;
        this.encodingDetector = new EncodingDetector();
    }

    public void preview(CSVImportSettings settings) {
        this.settings = settings;
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        CSVPanel cvsp = new CSVPanel();
        cvsp.autoDetectBusyLabel.setVisible(false);
        cvsp.autoDetectBusyLabel.setBusy(false);
        this.initBindings(settings, cvsp);
        JScrollPane tablePane = new JScrollPane();
        VTable prePreviewTable = new VTable();
        prePreviewTable.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        tablePane.add((Component)((Object)prePreviewTable));
        tablePane.setViewportView((Component)((Object)prePreviewTable));
        prePreviewTable.setFillsViewportHeight(true);
        jp.add(cvsp);
        jp.add(tablePane);
        this.view.addPreviewPane(jp);
        this.view.getSplitPane().setDividerLocation(-1);
        this.settings.addListener((a, b, c) -> {
            if (!this.settings.IGNORE_VISUAL_PROPERTIES.contains(a)) {
                this.enableControls2((JTable)((Object)prePreviewTable));
            }
        });
        this.enableControls2((JTable)((Object)prePreviewTable));
        this.view.setSize(this.view.getWidth() == 0 ? 800 : this.view.getWidth(), 550);
        this.view.setPreferredSize(new Dimension(this.view.getWidth() == 0 ? 800 : this.view.getWidth(), 550));
        this.view.revalidate();
        this.view.pack();
        this.bindActions(cvsp, (JTable)((Object)prePreviewTable));
    }

    private void enableControls2(final JTable prePreviewTable) {
        boolean enabled;
        boolean bl = enabled = this.settings != null && this.settings.getCharSeparator().length() > 0;
        if (enabled && this.ready) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setVisible(true);
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setCursor(new Cursor(3));
                        CSVPreferenceHandler.this.previewInternal(prePreviewTable);
                    }
                    finally {
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setVisible(false);
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setCursor(null);
                    }
                    return null;
                }
            }.execute();
        }
    }

    public CSVImportSettings getPreferences() {
        this.result = false;
        CSVPreferenceDialog cpg = new CSVPreferenceDialog((Frame)this.view.getFrame(), true);
        this.settings = new CSVImportSettings();
        cpg.tablePane.setViewportView((Component)((Object)cpg.prePreviewTable));
        cpg.cancelButton.addActionListener(l -> cpg.setVisible(false));
        cpg.okButton.addActionListener(l -> {
            this.result = true;
            cpg.setVisible(false);
        });
        this.initBindings(this.settings, cpg.getCSVPanel());
        this.enableControls(cpg);
        this.settings.addListener((a, b, c) -> {
            if (!this.settings.IGNORE_VISUAL_PROPERTIES.contains(a)) {
                this.enableControls(cpg);
            }
        });
        cpg.setTitle(this.model.getFileName());
        cpg.getCSVPanel().setVisible(true);
        cpg.setLocationRelativeTo(new JFrame(this.view.getGraphicsConfiguration()));
        this.bindActions(cpg.getCSVPanel(), (JTable)((Object)cpg.prePreviewTable));
        cpg.setVisible(true);
        if (this.result) {
            return this.settings;
        }
        return null;
    }

    private void bindActions(CSVPanel panel, JTable previewTable) {
        panel.autoDetectDatatypesButton.addActionListener(al -> {
            TableModel m = previewTable.getModel();
            if (m instanceof PreviewTableModel) {
                PreviewTableModel pv = (PreviewTableModel)m;
                new BackgroundRunner(() -> {
                    SwingUtilities.invokeLater(() -> {
                        cSVPanel.autoDetectDatatypesButton.setEnabled(false);
                        cSVPanel.autoDetectBusyLabel.setBusy(true);
                        cSVPanel.autoDetectBusyLabel.setVisible(true);
                    });
                    try {
                        ArrayList<StringDataTypeDetector> detectors = new ArrayList<StringDataTypeDetector>();
                        int i = 0;
                        while (i < pv.getColumnCount()) {
                            StringDataTypeDetector sd = new StringDataTypeDetector();
                            detectors.add(sd);
                            int j = 1;
                            while (j < pv.getRowCount()) {
                                if (!sd.addValue((String)pv.getValueAt(j, i))) break;
                                ++j;
                            }
                            ColumnType preftype = sd.getPreferredType();
                            previewTable.setValueAt(preftype, 0, i);
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(() -> {
                            cSVPanel.autoDetectBusyLabel.setBusy(false);
                            cSVPanel.autoDetectBusyLabel.setVisible(false);
                            cSVPanel.autoDetectDatatypesButton.setEnabled(true);
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(() -> {
                        cSVPanel.autoDetectBusyLabel.setBusy(false);
                        cSVPanel.autoDetectBusyLabel.setVisible(false);
                        cSVPanel.autoDetectDatatypesButton.setEnabled(true);
                    });
                }).execute();
            }
        });
        panel.resetDataTypes.addActionListener(al -> {
            TableModel m = previewTable.getModel();
            if (m instanceof PreviewTableModel) {
                PreviewTableModel pv = (PreviewTableModel)m;
                int answer = JOptionPane.showOptionDialog(this.view, "Do you want to reset all datatypes?", "Reset datatypes", 1, 1, null, new String[]{"Reset all", "Only reset autodetected", "Cancel"}, "Reset all");
                if (answer == 2) {
                    return;
                }
                int i = 0;
                while (i < pv.getColumnCount()) {
                    if (answer == 0) {
                        previewTable.setValueAt(ColumnType.TEXT, 0, i);
                    } else if (answer == 1) {
                        previewTable.setValueAt(ColumnType.TEXT, 0, i);
                    }
                    ++i;
                }
            }
        });
    }

    static void saveSettingsToConfig(CSVImportSettings settings) {
        Config config = ConfigHandler.getConfig();
        config.setConfigValue(IMPORT_CSV_SEPARATOR, settings.getCharSeparator());
        config.setConfigValue(IMPORT_CSV_QUOTE, settings.getQuotedChar());
        config.setConfigValue(IMPORT_CSV_FIRST_LINE_HEADER, settings.isFirstRowHeaders());
        config.setConfigValue(IMPORT_CSV_INCLUDE_ROW_NUMBER, settings.isIncludeRowNumberColumn());
    }

    private void initBindings(CSVImportSettings settings, CSVPanel panel) {
        APresenter<CSVImportSettings, CsvImportSettingModel, CSVPanel> presenter = new APresenter<CSVImportSettings, CsvImportSettingModel, CSVPanel>(new CsvImportSettingModel(), panel){

            protected void initBindings() {
                this.bind(((CSVPanel)this.view).firstLineHeaders).to(((CsvImportSettingModel)this.model).firstRowHeaders);
                this.bind(((CSVPanel)this.view).includeRowColumn).to(((CsvImportSettingModel)this.model).includeRowNumberColumn);
                this.bind(((CSVPanel)this.view).maxRowsSpinner).to(((CsvImportSettingModel)this.model).maxRows, Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(0), Integer.valueOf(1));
                this.bind(((CSVPanel)this.view).quoteOther, ((CSVPanel)this.view).quoteOtherText, new JRadioButton[]{((CSVPanel)this.view).quoteDoubleQuote, ((CSVPanel)this.view).quoteSingleQuote}).to(((CsvImportSettingModel)this.model).quotedChar, (Object[])new String[]{CSVPreferenceHandler.QUOTED_CHAR_DOUBLE_QUOTE, CSVPreferenceHandler.QUOTED_CHAR_SINGLE_QUOTE}).withMaxLength(1);
                this.bind(((CSVPanel)this.view).separatorOther, ((CSVPanel)this.view).separatorOtherText, new JRadioButton[]{((CSVPanel)this.view).separatorComma, ((CSVPanel)this.view).separatorPipe, ((CSVPanel)this.view).separatorSemiComma, ((CSVPanel)this.view).separatorTab}).to(((CsvImportSettingModel)this.model).charSeparator, (Object[])new String[]{CSVPreferenceHandler.CHAR_SEPARATOR_COMMA, CSVPreferenceHandler.CHAR_SEPARATOR_PIPE, CSVPreferenceHandler.CHAR_SEPARATOR_SEMI_COMMA, CSVPreferenceHandler.CHAR_SEPARATOR_TAB}).withMaxLength(1);
            }
        };
        Config config = ConfigHandler.getConfig();
        settings.setCharSeparator(config.getStringConfigValue(IMPORT_CSV_SEPARATOR, CHAR_SEPARATOR_TAB));
        settings.setQuotedChar(config.getStringConfigValue(IMPORT_CSV_QUOTE, QUOTED_CHAR_DOUBLE_QUOTE));
        settings.setFirstRowHeaders(config.getBooleanConfigValue(IMPORT_CSV_FIRST_LINE_HEADER, true));
        settings.setIncludeRowNumberColumn(config.getBooleanConfigValue(IMPORT_CSV_INCLUDE_ROW_NUMBER, true));
        presenter.setObject((Object)settings);
        this.ready = true;
    }

    private void enableControls(final CSVPreferenceDialog cpg) {
        boolean enabled = this.settings != null && this.settings.getCharSeparator().length() > 0;
        cpg.okButton.setEnabled(enabled);
        if (enabled && this.ready) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        cpg.getGlassPane().setVisible(true);
                        cpg.getGlassPane().setCursor(new Cursor(3));
                        CSVPreferenceHandler.this.previewInternal((JTable)((Object)cpg.prePreviewTable));
                    }
                    finally {
                        cpg.prePreviewTable.packAll();
                        cpg.getGlassPane().setVisible(false);
                        cpg.getGlassPane().setCursor(null);
                    }
                    return null;
                }
            }.execute();
        }
    }

    private void previewInternal(final JTable previewTable) {
        this.ready = false;
        File file = new File(this.model.getFileName());
        String encodingReal = this.encodingDetector.detectFileEncodingFast(file);
        String[] header = new String[]{};
        int rows = 0;
        int maxCols = 0;
        Vector data = new Vector();
        Vector<Object> headers = new Vector<Object>();
        PreviewTableRenderer pv = new PreviewTableRenderer();
        try {
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (SkipBOMReader r = new SkipBOMReader((InputStream)new FileInputStream(file), encodingReal);){
                    Throwable throwable2 = null;
                    Object var14_20 = null;
                    try (CsvListReader csv = new CsvListReader((Reader)r, this.getPrefs()){

                        public List<String> read() throws IOException {
                            if (this.readRow()) {
                                return this.getColumns();
                            }
                            return null;
                        }
                    };){
                        if (this.settings.isFirstRowHeaders()) {
                            header = csv.getHeader(false);
                        }
                        while (rows++ < (this.settings.getMaxRows() > 0 ? Math.min(200, this.settings.getMaxRows()) : 200)) {
                            List strings = csv.read();
                            if (strings == null) continue;
                            maxCols = Math.max(maxCols, strings.size());
                            data.add(new Vector(strings));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    headers.clear();
                    int i = 0;
                    while (i < maxCols) {
                        if (i <= header.length - 1) {
                            headers.add(header[i]);
                        } else {
                            headers.add(i);
                        }
                        ++i;
                    }
                    final ColumnSelected cs = new ColumnSelected(maxCols);
                    this.settings.setColumnsSelected(cs);
                    ArrayList<Column> sc = new ArrayList<Column>();
                    this.settings.setDbColumns(sc);
                    previewTable.setModel(new PreviewTableModel(headers, data, sc));
                    ColumnEditor cellEditor = new ColumnEditor();
                    int i2 = 0;
                    while (i2 < maxCols) {
                        TableColumnExt tc = (TableColumnExt)previewTable.getColumnModel().getColumn(i2);
                        tc.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(cs));
                        tc.setToolTipText("" + headers.get(i2));
                        tc.setCellRenderer((TableCellRenderer)pv);
                        tc.setCellEditor((TableCellEditor)cellEditor);
                        sc.add(new Column("" + headers.get(i2), ColumnType.TEXT));
                        ++i2;
                    }
                    previewTable.getTableHeader().addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            TableColumnModel columnModel = previewTable.getColumnModel();
                            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                            int modelColumn = previewTable.convertColumnIndexToModel(viewColumn);
                            cs.toggle(modelColumn + 1);
                            ((JTableHeader)e.getSource()).repaint();
                        }
                    });
                    if (headers.size() > 15) {
                        if (maxCols > 15) {
                            previewTable.setAutoResizeMode(0);
                        } else {
                            previewTable.setAutoResizeMode(4);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ready = true;
            }
        }
        finally {
            this.ready = true;
        }
    }

    private CsvPreference getPrefs() {
        return new CsvPreference.Builder(this.getQuoteChar(), this.settings.getCharSeparator().codePointAt(0), "").build();
    }

    private char getQuoteChar() {
        if (this.settings.getQuotedChar().length() == 0) {
            return '\u0000';
        }
        return this.settings.getQuotedChar().charAt(0);
    }

    @SoftCopy
    private class CsvImportSettingModel
    extends AModel<CSVImportSettings> {
        IProperty<String> quotedChar = this.getProperty("quotedChar");
        IProperty<String> charSeparator = this.getProperty("charSeparator");
        IProperty<Boolean> firstRowHeaders = this.getProperty("firstRowHeaders");
        IProperty<Boolean> includeRowNumberColumn = this.getProperty("includeRowNumberColumn");
        IProperty<Integer> maxRows = this.getProperty("maxRows");

        private CsvImportSettingModel() {
        }

        protected void copyObject(CSVImportSettings object) {
            this.copy = object;
        }
    }
}

