/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.filerunner.imports.core.AColumnSettings;
import com.sigge.filerunner.imports.core.ColumnEditor;
import com.sigge.filerunner.imports.core.ColumnSelected;
import com.sigge.filerunner.imports.core.HeaderRenderer;
import com.sigge.filerunner.imports.core.PreviewTableModel;
import com.sigge.filerunner.imports.core.PreviewTableRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.table.TableColumnExt;

public class ImportTablePreview {
    private final Vector data = new Vector();
    private final Vector headers = new Vector();
    private PreviewTableModel dataModel;

    public Vector getData() {
        return this.data;
    }

    public Vector getHeaders() {
        return this.headers;
    }

    public void setModelData(final JTable gridTable, AColumnSettings settings) {
        if (this.headers.size() > 6) {
            gridTable.setAutoResizeMode(0);
        } else {
            gridTable.setAutoResizeMode(4);
        }
        final ColumnSelected cs = new ColumnSelected(this.headers.size());
        settings.setColumnSelected(cs);
        ArrayList<Column> sc = new ArrayList<Column>();
        settings.setDbColumns(sc);
        this.dataModel = new PreviewTableModel(this.headers, this.data, sc);
        gridTable.setModel(this.dataModel);
        ColumnEditor cellEditor = new ColumnEditor();
        PreviewTableRenderer pv = new PreviewTableRenderer();
        int i = 0;
        while (i < this.headers.size()) {
            TableColumnExt tc = (TableColumnExt)gridTable.getColumnModel().getColumn(i);
            tc.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(cs));
            tc.setToolTipText("" + this.headers.get(i));
            tc.setCellRenderer((TableCellRenderer)pv);
            tc.setCellEditor((TableCellEditor)cellEditor);
            sc.add(new Column("" + this.headers.get(i), ColumnType.TEXT));
            ++i;
        }
        gridTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = gridTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int modelColumn = gridTable.convertColumnIndexToModel(viewColumn);
                cs.toggle(modelColumn + 1);
                ((JTableHeader)e.getSource()).repaint();
            }
        });
    }

    public PreviewTableModel getDataModel() {
        return this.dataModel;
    }
}

