/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.filerunner.imports.core.ColumnSelected;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public class HeaderRenderer
implements TableCellRenderer {
    private final ColumnSelected columns;

    public HeaderRenderer(ColumnSelected columns) {
        this.columns = columns;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer r = table.getTableHeader().getDefaultRenderer();
        JLabel l = (JLabel)r.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        l.setIcon(new CheckBoxIcon(this.columns.isSelected(column + 1)));
        return l;
    }

    private static class CheckBoxIcon
    implements Icon {
        private final JCheckBox check = new JCheckBox();

        public CheckBoxIcon(boolean check) {
            this.check.setSelected(check);
            this.check.setOpaque(false);
        }

        @Override
        public int getIconWidth() {
            return this.check.getPreferredSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.check.getPreferredSize().height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            SwingUtilities.paintComponent(g, this.check, (Container)c, x, y, this.getIconWidth(), this.getIconHeight());
        }
    }
}

