/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import com.sigge.dbrunner.sqlserver.SQLServerDatabaseConfig;
import com.sigge.filerunner.imports.core.FileImporter;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class EntryPoint {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        DbArgumentSupplier dbArgumentSupplier = new DbArgumentSupplier(args);
        FileImporter fi = new FileImporter(dbArgumentSupplier.server, dbArgumentSupplier.database);
        fi.addFileImportListener(() -> System.exit(0));
        fi.doImport(null);
    }

    private static class DbArgumentSupplier {
        private Database server;
        private String database;

        public DbArgumentSupplier(String[] args) {
            String server = null;
            String db = null;
            String user = null;
            String password = null;
            if (args.length > 0) {
                if (args.length != 4) {
                    System.err.println("Incorrect arguments provided! \nUse: excelimport server user password \nExample: excelimport localhost:1433 db user pass");
                    System.exit(1);
                }
            } else {
                throw new RuntimeException("No database setting provided");
            }
            server = args[0];
            db = args[1];
            user = args[2];
            password = args[3];
            this.server = new SQLServerDatabase(new SQLServerDatabaseConfig(server, user, password, false, null));
            this.database = db;
        }
    }
}

