/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.core.PreviewAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class BrowseForFileAction
extends AbstractAction {
    private final FileImporterModel model;
    private final PreviewAction previewAction;
    private final MainFrame view;

    public BrowseForFileAction(FileImporterModel model, MainFrame view, PreviewAction previewAction) {
        this.model = model;
        this.view = view;
        this.previewAction = previewAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        JFileChooser c = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String lastdir = prefs.get("lastdir", null);
        c.setCurrentDirectory(lastdir == null ? (this.model.getFileName().length() > 0 ? new File(this.model.getFileName()) : null) : new File(lastdir));
        int result = c.showOpenDialog(SwingUtilities.getWindowAncestor((JComponent)e.getSource()));
        if (result == 0 && (file = c.getSelectedFile()) != null) {
            this.model.setFileName(file.getPath());
            prefs.put("lastdir", file.getAbsolutePath());
            if (this.previewAction.isVisible()) {
                this.view.previewPane.removeAll();
                this.previewAction.preview();
            }
        }
    }
}

