/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.xml;

import com.sigge.filerunner.export.IExporter;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.siggemannen.view.ICompletionProgress;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLExporter
implements IExporter<Object> {
    @Override
    public boolean export(List<IResultSetTable> rstd, boolean selectionOnly, OutputStream outStream, Object preferences, ICompletionProgress progress) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element results = doc.createElement("root");
        doc.appendChild(results);
        Element rows = doc.createElement("rows");
        results.appendChild(rows);
        IResultSetTable rs = selectionOnly ? rstd.get(0).getSelectedSnapshot() : rstd.get(0);
        int i = 0;
        while (i < rs.getRowCount()) {
            if (progress.isCancelled()) {
                progress.status(100, "Cancelled");
                return false;
            }
            Element row = doc.createElement("row");
            rows.appendChild(row);
            int ii = 0;
            while (ii < rs.getColumnCount()) {
                String columnName = rs.getColumnName(ii);
                String value = rs.getValueForDisplay(i, ii);
                Element node = doc.createElement(columnName);
                if (value != null) {
                    node.appendChild(doc.createTextNode(value));
                }
                row.appendChild(node);
                ++ii;
            }
            ++i;
        }
        DOMSource domSource = new DOMSource(doc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        StreamResult sr = new StreamResult(outStream);
        transformer.transform(domSource, sr);
        return true;
    }
}

