/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.json;

import com.google.gson.stream.JsonWriter;
import com.sigge.filerunner.export.IExporter;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.TimeStampWrapperHandler;
import com.siggemannen.view.ICompletionProgress;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.List;
import microsoft.sql.DateTimeOffset;

public class JsonExporter
implements IExporter<Object> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean export(List<IResultSetTable> rstd, boolean selectionOnly, OutputStream outStream, Object preferences, ICompletionProgress progress) throws Exception {
        IResultSetTable rs = selectionOnly ? rstd.get(0).getSelectedSnapshot() : rstd.get(0);
        Throwable throwable = null;
        Object var8_9 = null;
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(outStream, StandardCharsets.UTF_8));){
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("rows");
            writer.beginArray();
            int i = 0;
            while (true) {
                if (i >= rs.getRowCount()) {
                    writer.endArray();
                    writer.endObject();
                    return true;
                }
                if (progress.isCancelled()) {
                    progress.status(100, "Cancelled");
                    return false;
                }
                try {
                    writer.beginObject();
                    int ii = 0;
                    while (true) {
                        block27: {
                            block26: {
                                if (ii >= rs.getColumnCount()) {
                                    writer.endObject();
                                    break;
                                }
                                String columnName = rs.getColumnName(ii);
                                Object value = rs.getValueAt(i, ii);
                                writer.name(columnName);
                                if (value == null) break block26;
                                switch (rs.getFieldType(ii)) {
                                    case SQLLONG: {
                                        writer.value(((Long)value).longValue());
                                        break block27;
                                    }
                                    case SQLBOOLEAN: {
                                        writer.value((Integer)value == 1);
                                        break block27;
                                    }
                                    case SQLINTEGER: {
                                        writer.value((long)((Integer)value).intValue());
                                        break block27;
                                    }
                                    case SQLFLOAT: {
                                        writer.value((Number)BigDecimal.valueOf((Double)value));
                                        break block27;
                                    }
                                    case SQLDATE: {
                                        writer.value(TimeStampWrapperHandler.getValue(value));
                                        break block27;
                                    }
                                    case SQLDATEWITHZONE: {
                                        writer.value(TimeStampWrapperHandler.getTimestampValue(((DateTimeOffset)value).getTimestamp()));
                                        break block27;
                                    }
                                    case SQLGEOMETRY: {
                                        writer.value(value.toString());
                                        break block27;
                                    }
                                    case SQLSTRING: 
                                    case SQLXMLSTRING: {
                                        writer.value((String)value);
                                        break block27;
                                    }
                                    default: {
                                        throw new RuntimeException("Unknown SQL-type " + (Object)((Object)rs.getFieldType(ii)) + " detected while fetching column value");
                                    }
                                }
                            }
                            writer.nullValue();
                        }
                        ++ii;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

