/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.inserts;

import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.dbrunner.table.ScriptOptions;
import com.sigge.filerunner.export.IExporter;
import com.sigge.filerunner.export.inserts.ScriptSetting;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.siggemannen.view.ICompletionProgress;
import java.io.OutputStream;
import java.util.List;

public class ScriptExporter
implements IExporter<ScriptSetting> {
    @Override
    public boolean export(List<IResultSetTable> rstd, boolean selectionOnly, OutputStream outStream, ScriptSetting preferences, ICompletionProgress progress) throws Exception {
        IResultSetTable rs = selectionOnly ? rstd.get(0).getSelectedSnapshot() : rstd.get(0);
        ServerDatabase sd = preferences.getDatabase();
        if (sd == null) {
            progress.status(100, "No current database, cannot script", new Exception("Current database must be selected"));
            return false;
        }
        ITableOperator to = sd.getDb().getDatabaseOperator().getTableOperator();
        ScriptOptions options = preferences.getOptions();
        options.setRowCounterCallback((row, rows) -> progress.status((int)(rs.getRowCount() > 0 ? 100.0 * (double)row.longValue() / (double)rs.getRowCount() : 0.0), "Processed: " + row + "/" + rs.getRowCount() + " rows"));
        options.setCancelled(() -> progress.isCancelled());
        to.script(rs.toResultSet(), outStream, options);
        return true;
    }
}

