/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.inserts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.export.ExportAction;
import com.sigge.filerunner.export.inserts.ScriptExporter;
import com.sigge.filerunner.export.inserts.ScriptSetting;
import com.sigge.filerunner.sql.OutputBuilder;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.export.scripter.IScriptOutputPresenter;
import java.util.List;
import javax.swing.JFrame;

@Singleton
public class ScriptExportAction
extends ExportAction<ScriptSetting> {
    private final SQLManager manager;
    @Inject
    private IScriptOutputPresenter sop;

    @Inject
    public ScriptExportAction(@Named(value="mainFrame") JFrame mainFrame, SQLManager manager) {
        super("SCRIPT", new ScriptExporter(), mainFrame);
        this.manager = manager;
    }

    @Override
    public ScriptSetting getPreferences(List<IResultSetTable> model, boolean selectionOnly) {
        OutputBuilder.ScriptOutput res = this.sop.present(this.container, true);
        if (res == null) {
            return null;
        }
        return new ScriptSetting(res.getPreferences(), this.manager.getCurrent(), ((OutputBuilder.FileOutput)res.getActualOutput()).getFile().getAbsolutePath());
    }

    @Override
    protected boolean isFilePerModel(List<IResultSetTable> model, boolean selectionOnly) {
        return true;
    }

    @Override
    public String getIcon() {
        return "script.png";
    }

    @Override
    public String getFile(ScriptSetting preferences) {
        if (preferences == null) {
            return null;
        }
        return preferences.getFileName();
    }
}

