/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.excel;

import com.sigge.filerunner.export.IExporter;
import com.sigge.filerunner.export.excel.ExcelHelper;
import com.sigge.filerunner.export.excel.ExcelSetting;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.siggemannen.view.ICompletionProgress;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelExporter
implements IExporter<ExcelSetting> {
    @Override
    public boolean export(List<IResultSetTable> rstds, boolean selectionOnly, OutputStream outStream, ExcelSetting preferences, ICompletionProgress progress) throws Exception {
        progress.status(0, "Creating workbook");
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        progress.status(0, "Created");
        int totalCount = rstds.stream().map(e -> selectionOnly ? e.getSelectedSnapshot() : e).mapToInt(IResultSetTable::getRowCount).sum();
        AtomicInteger ai = new AtomicInteger(0);
        try {
            int sheetNr = 0;
            while (sheetNr < rstds.size()) {
                IResultSetTable rstd = rstds.get(sheetNr);
                SXSSFSheet sh = wb.createSheet();
                int r = 0;
                if (selectionOnly) {
                    rstd = rstd.getSelectedSnapshot();
                }
                if (rstd.getColumnCount() > 0) {
                    String name;
                    sh.createFreezePane(0, 1);
                    if (preferences != null && preferences.getSheetNames().size() > sheetNr && (name = preferences.getSheetNames().get(sheetNr)) != null) {
                        name = name.replaceAll("[/\\?*\\]\\[:']", "_");
                        wb.setSheetName(sheetNr, name);
                    }
                    r = this.createHeader(rstd, (Sheet)sh, r);
                    int extraSheets = 0;
                    int rowIndex = 0;
                    while (rowIndex < rstd.getRowCount()) {
                        if (progress.isCancelled()) {
                            progress.status(100, "Cancelled");
                            return false;
                        }
                        if (rowIndex % 1048575 == 0 && rowIndex > 0) {
                            ++extraSheets;
                            sh = wb.createSheet();
                            sh.createFreezePane(0, 1);
                            if (preferences != null && preferences.getSheetNames().size() > sheetNr) {
                                wb.setSheetName(sheetNr + extraSheets, String.valueOf(preferences.getSheetNames().get(sheetNr)) + " #" + (extraSheets + 1));
                            }
                            r = this.createHeader(rstd, (Sheet)sh, 0);
                        }
                        if (rowIndex % 500 == 0) {
                            int processed = ai.get() + rowIndex;
                            progress.status((int)((double)processed * 1.0 / ((double)totalCount * 1.0) * 100.0), "Processed: " + processed + " / " + totalCount);
                        }
                        Row row = sh.createRow(r++);
                        int column = 0;
                        while (column < rstd.getColumnCount()) {
                            ExcelHelper.setExcelValueFromResultSetColumn(rstd.getFieldType(column), rstd.getValueAt(rowIndex, column), row.createCell(column), (Workbook)wb);
                            ++column;
                        }
                        ++rowIndex;
                    }
                    ai.addAndGet(rstd.getRowCount());
                }
                ++sheetNr;
            }
            progress.status(99, "Writing file");
            wb.write(outStream);
        }
        finally {
            outStream.close();
            wb.dispose();
            progress.status(100, "Done");
        }
        return true;
    }

    private int createHeader(IResultSetTable rstd, Sheet sh, int r) {
        Row header = sh.createRow(r++);
        int i = 0;
        while (i < rstd.getColumnCount()) {
            Cell cell = header.createCell(i);
            cell.setCellValue(rstd.getColumnName(i));
            ++i;
        }
        return r;
    }
}

