/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.excel;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.export.ExportAction;
import com.sigge.filerunner.export.excel.ExcelExporter;
import com.sigge.filerunner.export.excel.ExcelSetting;
import com.sigge.filerunner.export.excel.ExcelSettingsView;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetTableModelRenderer;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.ListTableElementModel;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.renderer.DefaultListRenderer;

@Singleton
public class ExcelAction
extends ExportAction<ExcelSetting> {
    private static final String DEFAULT_SHEET_NAME = "(Default sheet name)";
    private static final String EXCEL_EXTENSION = ".xlsx";
    private final JFrame mainFrame;

    @Inject
    public ExcelAction(@Named(value="mainFrame") JFrame mainFrame) {
        super("Excel", new ExcelExporter(), mainFrame);
        this.mainFrame = mainFrame;
    }

    @Override
    public String getFile(ExcelSetting preferences) {
        if (preferences != null && preferences.isCancelled()) {
            return null;
        }
        return this.getFileToExportTo(new FileNameExtensionFilter("Excel file (*.xlsx)", "xlsx"));
    }

    @Override
    public ExcelSetting getPreferences(final List<IResultSetTable> model, boolean selectionOnly) {
        if (model == null || model.size() <= 1) {
            return null;
        }
        JMemoryDialog memory = new JMemoryDialog(this.mainFrame, "Columns for sheet name", true, "excelActionSetting");
        if (!memory.isDefault()) {
            memory.setSize(640, 480);
        }
        ListTableElementModel<Tuple<IResultSetTable, Integer>, String> sheetModel = new ListTableElementModel<Tuple<IResultSetTable, Integer>, String>(Arrays.asList("Result", "Sheet name")){

            public Object getValueAt(int row, int column) {
                switch (column) {
                    case 0: {
                        return ((Tuple)this.getValueAt(row)).first();
                    }
                    case 1: {
                        return ((Tuple)this.getValueAt(row)).second();
                    }
                }
                return null;
            }

            public void setValueAt(Object aValue, int row, int column) {
                this.dataVector.set(row, Tuple.of((Object)((IResultSetTable)((Tuple)this.dataVector.get(row)).first()), (Object)((Integer)aValue)));
            }

            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        int i = 0;
        while (i < model.size()) {
            IResultSetTable rs = model.get(i);
            sheetModel.addRow((Object)Tuple.of((Object)rs, null));
            ++i;
        }
        ExcelSettingsView esv = new ExcelSettingsView();
        memory.getContentPane().add(esv);
        esv.columnTable.setModel((TableModel)sheetModel);
        esv.columnTable.getColumn(0).setCellRenderer(new ResultSetTableModelRenderer());
        final JComboBox columnCombo = new JComboBox();
        DefaultCellEditor comboEditor = new DefaultCellEditor(columnCombo){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, int column) {
                columnCombo.setRenderer(new DefaultListRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        JLabel jl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        if (value != null) {
                            jl.setText(((IResultSetTable)model.get(row)).getColumnName((Integer)value));
                        } else {
                            jl.setText(ExcelAction.DEFAULT_SHEET_NAME);
                        }
                        return jl;
                    }
                });
                Vector<Integer> vege = new Vector<Integer>();
                vege.add(null);
                int i = 0;
                while (i < ((IResultSetTable)model.get(row)).getColumnCount()) {
                    vege.add(i);
                    ++i;
                }
                columnCombo.setModel(new DefaultComboBoxModel(vege));
                return columnCombo;
            }
        };
        esv.columnTable.getColumn(1).setCellEditor(comboEditor);
        esv.columnTable.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel jl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    try {
                        jl.setText(((IResultSetTable)model.get(row)).getColumnName((Integer)value));
                    }
                    catch (Exception exception) {}
                } else {
                    jl.setText(ExcelAction.DEFAULT_SHEET_NAME);
                }
                return jl;
            }
        });
        memory.addOKAction(esv.exportButton);
        memory.addCancelAction(esv.cancelButton);
        memory.centerOnCorrectScreen(this.container);
        memory.setVisible(true);
        if (memory.getReturnStatus() == 1) {
            return new ExcelSetting(sheetModel.getDataVector().stream().map(t -> {
                String valueAt;
                if (t.second() == null) {
                    return null;
                }
                IResultSetTable first = (IResultSetTable)t.first();
                if (first.getRowCount() > 0 && (valueAt = first.getValueForDisplay(0, (Integer)t.second())) != null) {
                    return valueAt;
                }
                return first.getColumnName((Integer)t.second());
            }).collect(Collectors.toList()));
        }
        return ExcelSetting.cancelled();
    }

    @Override
    public String getIcon() {
        return "xls.png";
    }
}

