/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.fileutils.EncodingDetector;
import com.sigge.fileutils.SkipBOMReader;
import com.siggemannen.core.Tuple;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileUtils {
    private static final EncodingDetector ed = new EncodingDetector();
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public static boolean hasExtension(Path p, String extensionWithoutDot) {
        int length = extensionWithoutDot.length();
        String name = p.toFile().getName();
        if (name.length() < length + 1) {
            return false;
        }
        return name.substring(name.length() - length - 1).toLowerCase().equals("." + extensionWithoutDot);
    }

    public static boolean hasExtension(File file, String ... extensions) {
        String ext;
        String filename = file.getName();
        int extensionPos = filename.lastIndexOf(".");
        int lastSeparator = FileUtils.indexOfLastSeparator(filename);
        int index = lastSeparator > extensionPos ? -1 : extensionPos;
        String string = ext = index == -1 ? "" : filename.substring(index, filename.length());
        if (index == -1) {
            return "".equals(ext);
        }
        String exts = filename.substring(index + 1);
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (exts.equalsIgnoreCase(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf("/");
        int lastWindowsPos = filename.lastIndexOf("\\");
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String getExtension(File f) {
        String name = f.getName();
        if (name.contains(".")) {
            return name.substring(name.lastIndexOf("."));
        }
        return null;
    }

    public static String getFileWithoutExtension(File f) {
        String name = f.getAbsolutePath();
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static boolean hasNoExtension(File f) {
        String name = f.getName();
        return !name.contains(".") || name.endsWith(".");
    }

    public static List<File> openFiles(Component comp, File preferredDirectory, FileFilter ... filters) {
        JFileChooser fc = new JFileChooser();
        FileFilter ff = fc.getAcceptAllFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(true);
        File dir = preferredDirectory;
        if (dir != null && dir.exists() && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        } else {
            FileUtils.setLastDirectory(fc);
        }
        FileFilter[] fileFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            fc.addChoosableFileFilter(filter);
            ++n2;
        }
        fc.addChoosableFileFilter(ff);
        int result = fc.showOpenDialog(comp);
        if (result == 0) {
            List<File> f = Arrays.asList(fc.getSelectedFiles());
            int i = f.size() - 1;
            while (i >= 0) {
                if (f.get(i).isDirectory()) {
                    f.remove(i);
                }
                --i;
            }
            if (f.size() > 0) {
                dir = f.get(0).getParentFile();
                if (dir != null && dir.exists() && dir.isDirectory()) {
                    ConfigHandler.getConfig().setLastDirectory(dir.getAbsolutePath());
                    ConfigHandler.saveInBackground();
                }
                return f;
            }
        }
        return null;
    }

    public static File openFile(Component comp, FileFilter ... filters) {
        JFileChooser fc = new JFileChooser();
        FileFilter ff = fc.getAcceptAllFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        FileUtils.setLastDirectory(fc);
        FileFilter[] fileFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            fc.addChoosableFileFilter(filter);
            ++n2;
        }
        fc.addChoosableFileFilter(ff);
        int result = fc.showOpenDialog(comp);
        return FileUtils.getFileFromFileChooserResult(fc, result);
    }

    private static void setLastDirectory(JFileChooser fc) {
        File dir;
        String file = ConfigHandler.getConfig().getLastDirectory();
        if (file != null && (dir = new File(file)).exists() && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
    }

    public static File saveFile(Component comp, String preferredName, FileFilter ... filters) {
        int result;
        JFileChooser fc = new JFileChooser();
        FileFilter ff = fc.getAcceptAllFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            fc.addChoosableFileFilter(filter);
            ++n2;
        }
        fc.addChoosableFileFilter(ff);
        FileUtils.setLastDirectory(fc);
        if (!StringUtils.isEmpty(preferredName)) {
            fc.setSelectedFile(new File(preferredName));
        }
        if ((result = fc.showSaveDialog(comp)) == 0) {
            return FileUtils.getFileChosen(fc, comp, FileUtils.getFileFromFileChooserResult(fc, result), ((FileNameExtensionFilter)filters[0]).getExtensions()[0]);
        }
        return null;
    }

    public static String streamContents(InputStream ios, String encoding) throws IOException {
        Tuple<Integer, char[]> res = FileUtils.readStream(ios, encoding);
        return new String((char[])res.second(), 0, (int)((Integer)res.first()));
    }

    public static String fileContent(File file, String encoding) throws FileNotFoundException, IOException {
        Tuple<Integer, Tuple<char[], String>> res = FileUtils.fileContents(file, encoding);
        return new String((char[])((Tuple)res.second()).first(), 0, (int)((Integer)res.first()));
    }

    public static Tuple<String, String> fileContent(File file) throws FileNotFoundException, IOException {
        Tuple<Integer, Tuple<char[], String>> res = FileUtils.fileContents(file, null);
        return Tuple.of((Object)new String((char[])((Tuple)res.second()).first(), 0, (int)((Integer)res.first())), (Object)((String)((Tuple)res.second()).second()));
    }

    public static Tuple<Integer, char[]> readStream(InputStream ios, String encodingReal) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = new BufferedReader((Reader)new SkipBOMReader(ios, encodingReal));){
            int result;
            char[] buffer = new char[8192];
            char[] full = new char[]{};
            int len = 0;
            while ((result = r.read(buffer)) != -1) {
                if ((len += result) > full.length) {
                    full = Arrays.copyOf(full, FileUtils.newCapacity(full, len));
                }
                System.arraycopy(buffer, 0, full, len - result, result);
            }
            r.close();
            return new Tuple((Object)len, (Object)full);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static File getFileFromFileChooserResult(JFileChooser fc, int result) {
        File f;
        if (result == 0 && (f = fc.getSelectedFile()) != null) {
            File dir = f.getParentFile();
            if (dir.exists() && dir.isDirectory()) {
                ConfigHandler.getConfig().setLastDirectory(dir.getAbsolutePath());
                ConfigHandler.saveInBackground();
            }
            return f;
        }
        return null;
    }

    public static File getFileChosen(JFileChooser fc, Component comp, File f, String forceExtension) {
        File fileToSave = null;
        if (forceExtension != null && !fc.getFileFilter().accept(f) && FileUtils.hasNoExtension(f)) {
            f = new File(String.valueOf(f.getAbsolutePath()) + "." + forceExtension);
        }
        if (!f.exists() || JOptionPane.showConfirmDialog(comp, "Do you want to overwrite file: " + f.getName() + "?", "Are you sure?", 0) == 0) {
            fileToSave = f;
        }
        return fileToSave;
    }

    public static Tuple<Integer, Tuple<char[], String>> fileContents(File file) throws FileNotFoundException, IOException {
        return FileUtils.fileContents(file, null);
    }

    private static Tuple<Integer, Tuple<char[], String>> fileContents(File file, String encoding) throws FileNotFoundException, IOException {
        String encodingReal = null;
        byte[] contents = null;
        if (encoding != null && !encoding.equals("")) {
            encodingReal = encoding;
        } else {
            Tuple cont = ed.detectFileEncodingAndGetContent(new File(file.getPath()));
            encodingReal = (String)cont.second();
            contents = (byte[])cont.first();
        }
        Tuple<Integer, char[]> v = FileUtils.readStream(contents == null ? new FileInputStream(new File(file.getPath())) : new ByteArrayInputStream(contents), encodingReal);
        return Tuple.of((Object)((Integer)v.first()), (Object)Tuple.of((Object)((char[])v.second()), (Object)encodingReal));
    }

    private static int newCapacity(char[] value, int minCapacity) {
        int newCapacity = (value.length << 1) + 2;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        return newCapacity <= 0 || 0x7FFFFFF7 - newCapacity < 0 ? FileUtils.hugeCapacity(minCapacity) : newCapacity;
    }

    private static int hugeCapacity(int minCapacity) {
        if (Integer.MAX_VALUE - minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? minCapacity : 0x7FFFFFF7;
    }

    public static void displayFileMessages(List<Tuple<File, String>> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        StringBuilder m = new StringBuilder("Error occured while opening files:\n");
        for (Tuple<File, String> file : messages) {
            m.append(" - ").append(((File)file.first()).getAbsolutePath()).append(": ").append((String)file.second()).append("\n");
        }
        JOptionPane.showMessageDialog(null, m.toString(), "Error while opening files", 0, null);
    }
}

